/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.bulktag.community;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.dhp.bulktag.community.Community;
import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.bulktag.community.Provider;
import eu.dnetlib.dhp.bulktag.community.ZenodoCommunity;
import eu.dnetlib.dhp.bulktag.criteria.InterfaceAdapter;
import eu.dnetlib.dhp.bulktag.criteria.Selection;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolver;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolverFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class CommunityConfigurationFactory {
    private static final Log log = LogFactory.getLog(CommunityConfigurationFactory.class);
    private static final VerbResolver resolver = VerbResolverFactory.newInstance();

    public static CommunityConfiguration newInstance(String xml) throws DocumentException {
        log.debug((Object)String.format("parsing community configuration from:\n%s", xml));
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        HashMap communities = Maps.newHashMap();
        for (Object o : doc.selectNodes("//community")) {
            Node node = (Node)o;
            Community community = CommunityConfigurationFactory.parseCommunity(node);
            if (!community.isValid()) continue;
            communities.put(community.getId(), community);
        }
        log.info((Object)String.format("loaded %s community configuration profiles", communities.size()));
        log.debug((Object)String.format("loaded community configuration:\n%s", communities));
        return new CommunityConfiguration(communities);
    }

    public static CommunityConfiguration fromJson(String json) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Selection.class, (Object)new InterfaceAdapter());
        Gson gson = builder.create();
        CommunityConfiguration conf = (CommunityConfiguration)gson.fromJson(json, CommunityConfiguration.class);
        log.info((Object)String.format("loaded %s community configuration profiles", conf.size()));
        conf.init();
        log.info((Object)"created inverse maps");
        return conf;
    }

    private static Community parseCommunity(Node node) {
        Community c = new Community();
        c.setId(node.valueOf("./@id"));
        log.info((Object)String.format("community id: %s", c.getId()));
        c.setSubjects(CommunityConfigurationFactory.parseSubjects(node));
        c.setProviders(CommunityConfigurationFactory.parseDatasources(node));
        c.setZenodoCommunities(CommunityConfigurationFactory.parseZenodoCommunities(node));
        return c;
    }

    private static List<String> parseSubjects(Node node) {
        ArrayList subjects = Lists.newArrayList();
        List list = node.selectNodes("./subjects/subject");
        for (Node n : list) {
            log.debug((Object)("text of the node " + n.getText()));
            subjects.add(StringUtils.trim((String)n.getText()));
        }
        log.info((Object)("size of the subject list " + subjects.size()));
        return subjects;
    }

    private static List<Provider> parseDatasources(Node node) {
        List list = node.selectNodes("./datasources/datasource");
        ArrayList<Provider> providerList = new ArrayList<Provider>();
        for (Node n : list) {
            Provider d = new Provider();
            d.setOpenaireId(n.selectSingleNode("./openaireId").getText());
            d.setSelCriteria(n.selectSingleNode("./selcriteria"), resolver);
            providerList.add(d);
        }
        log.info((Object)("size of the datasource list " + providerList.size()));
        return providerList;
    }

    private static List<ZenodoCommunity> parseZenodoCommunities(Node node) {
        List list = node.selectNodes("./zenodocommunities/zenodocommunity");
        ArrayList<ZenodoCommunity> zenodoCommunityList = new ArrayList<ZenodoCommunity>();
        for (Node n : list) {
            ZenodoCommunity zc = new ZenodoCommunity();
            zc.setZenodoCommunityId(n.selectSingleNode("./zenodoid").getText());
            zc.setSelCriteria(n.selectSingleNode("./selcriteria"));
            zenodoCommunityList.add(zc);
        }
        log.info((Object)("size of the zenodo community list " + zenodoCommunityList.size()));
        return zenodoCommunityList;
    }
}

