/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.countrypropagation;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.countrypropagation.DatasourceCountry;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareDatasourceCountryAssociation {
    private static final Logger log = LoggerFactory.getLogger(PrepareDatasourceCountryAssociation.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareDatasourceCountryAssociation.class.getResourceAsStream("/eu/dnetlib/dhp/countrypropagation/input_prepareassoc_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareDatasourceCountryAssociation.prepareDatasourceCountryAssociation(spark, Arrays.asList(parser.get("whitelist").split(";")), Arrays.asList(parser.get("allowedtypes").split(";")), inputPath, outputPath);
        });
    }

    private static void prepareDatasourceCountryAssociation(SparkSession spark, List<String> whitelist, List<String> allowedtypes, String inputPath, String outputPath) {
        String whitelisted = whitelist.stream().map(id -> " d.id = '" + id + "'").collect(Collectors.joining(" OR "));
        String allowed = allowedtypes.stream().map(type -> " d.datasourcetype.classid = '" + type + "'").collect(Collectors.joining(" OR "));
        Dataset<Datasource> datasource = PropagationConstant.readPath(spark, inputPath + "/datasource", Datasource.class);
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputPath + "/relation", Relation.class);
        Dataset<Organization> organization = PropagationConstant.readPath(spark, inputPath + "/organization", Organization.class);
        datasource.createOrReplaceTempView("datasource");
        relation.createOrReplaceTempView("relation");
        organization.createOrReplaceTempView("organization");
        String query = "SELECT source dataSourceId, named_struct('classid', country.classid, 'classname', country.classname) country FROM datasource d JOIN relation rel ON d.id = rel.source JOIN organization o ON o.id = rel.target WHERE rel.datainfo.deletedbyinference = false  and lower(rel.relclass) = '" + "isProvidedBy".toLowerCase() + "'and o.datainfo.deletedbyinference = false  and length(o.country.classid) > 0 and (" + allowed + " or " + whitelisted + ")";
        spark.sql(query).as(Encoders.bean(DatasourceCountry.class)).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(outputPath);
    }
}

