/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.orcidtoresultfromsemrel;

import com.google.gson.Gson;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.ResultOrcidList;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResultOrcidAssociationStep1 {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultOrcidAssociationStep1.class);

    public static void main(String[] args) throws Exception {
        String jsonConf = IOUtils.toString((InputStream)PrepareResultOrcidAssociationStep1.class.getResourceAsStream("/eu/dnetlib/dhp/orcidtoresultfromsemrel/input_prepareorcidtoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConf);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String resultClassName = parser.get("resultTableName");
        log.info("resultTableName: {}", (Object)resultClassName);
        List<String> allowedsemrel = Arrays.asList(parser.get("allowedsemrels").split(";"));
        log.info("allowedSemRel: {}", (Object)new Gson().toJson(allowedsemrel));
        String resultType = resultClassName.substring(resultClassName.lastIndexOf(".") + 1).toLowerCase();
        log.info("resultType: {}", (Object)resultType);
        Class<?> resultClazz = Class.forName(resultClassName);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        String inputRelationPath = inputPath + "/relation";
        log.info("inputRelationPath: {}", (Object)inputRelationPath);
        String inputResultPath = inputPath + "/" + resultType;
        log.info("inputResultPath: {}", (Object)inputResultPath);
        String outputResultPath = outputPath + "/" + resultType;
        log.info("outputResultPath: {}", (Object)outputResultPath);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareResultOrcidAssociationStep1.prepareInfo(spark, inputRelationPath, inputResultPath, outputResultPath, resultClazz, allowedsemrel);
        });
    }

    private static <R extends Result> void prepareInfo(SparkSession spark, String inputRelationPath, String inputResultPath, String outputResultPath, Class<R> resultClazz, List<String> allowedsemrel) {
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputRelationPath, Relation.class);
        relation.createOrReplaceTempView("relation");
        log.info("Reading Graph table from: {}", (Object)inputResultPath);
        Dataset<R> result = PropagationConstant.readPath(spark, inputResultPath, resultClazz);
        result.createOrReplaceTempView("result");
        String query = "SELECT target resultId, author authorList  FROM (SELECT id, collect_set(named_struct('name', name, 'surname', surname, 'fullname', fullname, 'orcid', orcid)) author         FROM (                SELECT DISTINCT id, MyT.fullname, MyT.name, MyT.surname, MyP.value orcid                FROM result                LATERAL VIEW EXPLODE (author) a AS MyT                LATERAL VIEW EXPLODE (MyT.pid) p AS MyP                WHERE lower(MyP.qualifier.classid) = 'orcid' or                        lower(MyP.qualifier.classid) = 'orcid_pending') tmp                GROUP BY id) r_t  JOIN (        SELECT source, target         FROM relation         WHERE datainfo.deletedbyinference = false " + PropagationConstant.getConstraintList(" lower(relclass) = '", allowedsemrel) + "              ) rel_rel  ON source = id";
        log.info("executedQuery: {}", (Object)query);
        spark.sql(query).as(Encoders.bean(ResultOrcidList.class)).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(outputResultPath);
    }
}

