/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.bulktag;

import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.bulktag.community.CommunityConfigurationFactory;
import eu.dnetlib.dhp.bulktag.community.Constraint;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class CommunityConfigurationFactoryTest {
    private final VerbResolver resolver = new VerbResolver();

    CommunityConfigurationFactoryTest() {
    }

    @Test
    void parseTest() throws DocumentException, IOException, SAXException {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/bulktag/communityconfiguration/community_configuration.xml"));
        CommunityConfiguration cc = CommunityConfigurationFactory.newInstance((String)xml);
        Assertions.assertEquals((int)5, (int)cc.size());
        cc.getCommunityList().forEach(c -> Assertions.assertTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.getId()})));
    }

    @Test
    void applyVerb() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        Constraint sc = new Constraint();
        sc.setVerb("not_contains");
        sc.setField("contributor");
        sc.setValue("DARIAH");
        sc.setSelection(this.resolver.getSelectionCriteria(sc.getVerb(), sc.getValue()));
        String metadata = "This work has been partially supported by DARIAH-EU infrastructure";
        Assertions.assertFalse((boolean)sc.verifyCriteria(metadata));
    }

    @Test
    void loadSelCriteriaTest() throws DocumentException, IOException, SAXException {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/bulktag/communityconfiguration/community_configuration_selcrit.xml"));
        CommunityConfiguration cc = CommunityConfigurationFactory.newInstance((String)xml);
        HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>();
        param.put("author", new ArrayList<String>(Collections.singletonList("Pippo Pippi")));
        param.put("description", new ArrayList<String>(Collections.singletonList("This work has been partially supported by DARIAH-EU infrastructure")));
        param.put("contributor", new ArrayList<String>(Collections.singletonList("Author X helped to write the paper. X works for DARIAH")));
        List comm = cc.getCommunityForDatasource("openaire____::1cfdb2e14977f31a98e0118283401f32", param);
        Assertions.assertEquals((int)1, (int)comm.size());
        Assertions.assertEquals((Object)"dariah", comm.get(0));
    }
}

