/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttocommunityfromsemrel;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttocommunityfromorganization.ResultCommunityList;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareResultCommunitySetStep2 {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultCommunitySetStep2.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultCommunitySetStep2.class.getResourceAsStream("/eu/dnetlib/dhp/resulttocommunityfromsemrel/input_preparecommunitytoresult2_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareResultCommunitySetStep2.mergeInfo(spark, inputPath, outputPath);
        });
    }

    private static void mergeInfo(SparkSession spark, String inputPath, String outputPath) {
        Dataset resultOrcidAssocCommunityList = PropagationConstant.readPath(spark, inputPath + "/publication", ResultCommunityList.class).union(PropagationConstant.readPath(spark, inputPath + "/dataset", ResultCommunityList.class)).union(PropagationConstant.readPath(spark, inputPath + "/otherresearchproduct", ResultCommunityList.class)).union(PropagationConstant.readPath(spark, inputPath + "/software", ResultCommunityList.class));
        resultOrcidAssocCommunityList.toJavaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getResultId(), r)).reduceByKey((Function2 & Serializable)(a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            HashSet community_set = new HashSet();
            a.getCommunityList().stream().forEach(aa -> community_set.add(aa));
            b.getCommunityList().stream().forEach(aa -> {
                if (!community_set.contains(aa)) {
                    a.getCommunityList().add((String)aa);
                    community_set.add(aa);
                }
            });
            return a;
        }).map(Tuple2::_2).map((Function & Serializable)r -> OBJECT_MAPPER.writeValueAsString(r)).saveAsTextFile(outputPath, GzipCodec.class);
    }
}

