/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.projecttoresult;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.projecttoresult.ResultProjectSet;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkResultToProjectThroughSemRelJob {
    private static final Logger log = LoggerFactory.getLogger(SparkResultToProjectThroughSemRelJob.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)SparkResultToProjectThroughSemRelJob.class.getResourceAsStream("/eu/dnetlib/dhp/projecttoresult/input_projecttoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        String potentialUpdatePath = parser.get("potentialUpdatePath");
        log.info("potentialUpdatePath {}: ", (Object)potentialUpdatePath);
        String alreadyLinkedPath = parser.get("alreadyLinkedPath");
        log.info("alreadyLinkedPath {}: ", (Object)alreadyLinkedPath);
        Boolean saveGraph = Boolean.valueOf(parser.get("saveGraph"));
        log.info("saveGraph: {}", (Object)saveGraph);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            if (PropagationConstant.isTest(parser).booleanValue()) {
                PropagationConstant.removeOutputDir(spark, outputPath);
            }
            SparkResultToProjectThroughSemRelJob.execPropagation(spark, outputPath, alreadyLinkedPath, potentialUpdatePath, saveGraph);
        });
    }

    private static void execPropagation(SparkSession spark, String outputPath, String alreadyLinkedPath, String potentialUpdatePath, Boolean saveGraph) {
        Dataset<ResultProjectSet> toaddrelations = PropagationConstant.readPath(spark, potentialUpdatePath, ResultProjectSet.class);
        Dataset<ResultProjectSet> alreadyLinked = PropagationConstant.readPath(spark, alreadyLinkedPath, ResultProjectSet.class);
        if (saveGraph.booleanValue()) {
            toaddrelations.joinWith(alreadyLinked, toaddrelations.col("resultId").equalTo((Object)alreadyLinked.col("resultId")), "left_outer").flatMap(SparkResultToProjectThroughSemRelJob.mapRelationRn(), Encoders.bean(Relation.class)).write().mode(SaveMode.Append).option("compression", "gzip").json(outputPath);
        }
    }

    private static FlatMapFunction<Tuple2<ResultProjectSet, ResultProjectSet>, Relation> mapRelationRn() {
        return (FlatMapFunction & Serializable)value -> {
            ArrayList newRelations = new ArrayList();
            ResultProjectSet potentialUpdate = (ResultProjectSet)value._1();
            Optional<Object> alreadyLinked = Optional.ofNullable(value._2());
            alreadyLinked.ifPresent(resultProjectSet -> resultProjectSet.getProjectSet().forEach(p -> potentialUpdate.getProjectSet().remove(p)));
            String resId = potentialUpdate.getResultId();
            potentialUpdate.getProjectSet().forEach(projectId -> {
                newRelations.add(PropagationConstant.getRelation(resId, projectId, "isProducedBy", "resultProject", "outcome", "propagation", "result:project:semrel", "Propagation of result to project through semantic relation"));
                newRelations.add(PropagationConstant.getRelation(projectId, resId, "produces", "resultProject", "outcome", "propagation", "result:project:semrel", "Propagation of result to project through semantic relation"));
            });
            return newRelations.iterator();
        };
    }
}

