/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttocommunityfromsemrel;

import com.google.gson.Gson;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttocommunityfromorganization.ResultCommunityList;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResultCommunitySetStep1 {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultCommunitySetStep1.class);
    private static final String COMMUNITY_LIST_XQUERY = "for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')  where $x//CONFIGURATION/context[./@type='community' or ./@type='ri']  and  $x//CONFIGURATION/context/param[./@name='status']/text() != 'hidden'  return $x//CONFIGURATION/context/@id/string()";
    private static final String RESULT_CONTEXT_QUERY_TEMPLATE = "select target resultId, community_context  from (select id, collect_set(co.id) community_context        from  result        lateral view explode (context) c as co        where datainfo.deletedbyinference = false %s group by id) p  JOIN  (select source, target from relation   where datainfo.deletedbyinference = false %s ) r ON p.id = r.source";
    private static final String RESULT_COMMUNITY_LIST_QUERY = "select resultId , collect_set(co) communityList from result_context lateral view explode (community_context) c as co where length(co) > 0 group by resultId";

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultCommunitySetStep1.class.getResourceAsStream("/eu/dnetlib/dhp/resulttocommunityfromsemrel/input_preparecommunitytoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String resultClassName = parser.get("resultTableName");
        log.info("resultTableName: {}", (Object)resultClassName);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        List<String> allowedsemrel = Arrays.asList(parser.get("allowedsemrels").split(";"));
        log.info("allowedSemRel: {}", (Object)new Gson().toJson(allowedsemrel));
        String isLookupUrl = parser.get("isLookUpUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        List<String> communityIdList = PrepareResultCommunitySetStep1.getCommunityList(isLookupUrl);
        log.info("communityIdList: {}", (Object)new Gson().toJson(communityIdList));
        String resultType = resultClassName.substring(resultClassName.lastIndexOf(".") + 1).toLowerCase();
        log.info("resultType: {}", (Object)resultType);
        Class<?> resultClazz = Class.forName(resultClassName);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            if (PropagationConstant.isTest(parser).booleanValue()) {
                PropagationConstant.removeOutputDir(spark, outputPath);
            }
            PrepareResultCommunitySetStep1.prepareInfo(spark, inputPath, outputPath, allowedsemrel, resultClazz, resultType, communityIdList);
        });
    }

    private static <R extends Result> void prepareInfo(SparkSession spark, String inputPath, String outputPath, List<String> allowedsemrel, Class<R> resultClazz, String resultType, List<String> communityIdList) {
        String inputResultPath = inputPath + "/" + resultType;
        log.info("Reading Graph table from: {}", (Object)inputResultPath);
        String inputRelationPath = inputPath + "/relation";
        log.info("Reading relation table from: {}", (Object)inputResultPath);
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputRelationPath, Relation.class);
        relation.createOrReplaceTempView("relation");
        Dataset<R> result = PropagationConstant.readPath(spark, inputResultPath, resultClazz);
        result.createOrReplaceTempView("result");
        String outputResultPath = outputPath + "/" + resultType;
        log.info("writing output results to: {}", (Object)outputResultPath);
        String resultContextQuery = String.format(RESULT_CONTEXT_QUERY_TEMPLATE, PropagationConstant.getConstraintList(" lower(co.id) = '", communityIdList), PropagationConstant.getConstraintList(" lower(relClass) = '", allowedsemrel));
        Dataset result_context = spark.sql(resultContextQuery);
        result_context.createOrReplaceTempView("result_context");
        spark.sql(RESULT_COMMUNITY_LIST_QUERY).as(Encoders.bean(ResultCommunityList.class)).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(outputResultPath);
    }

    public static List<String> getCommunityList(String isLookupUrl) throws ISLookUpException {
        ISLookUpService isLookUp = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        return isLookUp.quickSearchProfile(COMMUNITY_LIST_XQUERY);
    }
}

