/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttocommunityfromorganization;

import com.google.gson.Gson;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttocommunityfromorganization.OrganizationMap;
import eu.dnetlib.dhp.resulttocommunityfromorganization.ResultCommunityList;
import eu.dnetlib.dhp.resulttocommunityfromorganization.ResultOrganizations;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareResultCommunitySet {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultCommunitySet.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultCommunitySet.class.getResourceAsStream("/eu/dnetlib/dhp/resulttocommunityfromorganization/input_preparecommunitytoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        OrganizationMap organizationMap = (OrganizationMap)new Gson().fromJson(parser.get("organizationtoresultcommunitymap"), OrganizationMap.class);
        log.info("organizationMap: {}", (Object)new Gson().toJson((Object)organizationMap));
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareResultCommunitySet.prepareInfo(spark, inputPath, outputPath, organizationMap);
        });
    }

    private static void prepareInfo(SparkSession spark, String inputPath, String outputPath, OrganizationMap organizationMap) {
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputPath, Relation.class);
        relation.createOrReplaceTempView("relation");
        String query = "SELECT result_organization.source resultId, result_organization.target orgId, org_set merges FROM (SELECT source, target       FROM relation       WHERE datainfo.deletedbyinference = false       AND lower(relClass) = '" + "hasAuthorInstitution".toLowerCase() + "') result_organization LEFT JOIN (SELECT source, collect_set(target) org_set       FROM relation       WHERE datainfo.deletedbyinference = false       AND lower(relClass) = '" + "merges".toLowerCase() + "'       GROUP BY source) organization_organization ON result_organization.target = organization_organization.source ";
        Dataset result_organizationset = spark.sql(query).as(Encoders.bean(ResultOrganizations.class));
        result_organizationset.map(PrepareResultCommunitySet.mapResultCommunityFn(organizationMap), Encoders.bean(ResultCommunityList.class)).filter(Objects::nonNull).toJavaRDD().mapToPair((PairFunction & Serializable)value -> new Tuple2((Object)value.getResultId(), value)).reduceByKey((Function2 & Serializable)(a, b) -> {
            ArrayList<String> cl = a.getCommunityList();
            b.getCommunityList().stream().forEach(s -> {
                if (!cl.contains(s)) {
                    cl.add((String)s);
                }
            });
            a.setCommunityList(cl);
            return a;
        }).map((Function & Serializable)value -> PropagationConstant.OBJECT_MAPPER.writeValueAsString(value._2())).saveAsTextFile(outputPath, GzipCodec.class);
    }

    private static MapFunction<ResultOrganizations, ResultCommunityList> mapResultCommunityFn(OrganizationMap organizationMap) {
        return (MapFunction & Serializable)value -> {
            String rId = value.getResultId();
            Optional<ArrayList<String>> orgs = Optional.ofNullable(value.getMerges());
            String oTarget = value.getOrgId();
            HashSet<String> communitySet = new HashSet<String>();
            if (organizationMap.containsKey(oTarget)) {
                communitySet.addAll(organizationMap.get(oTarget));
            }
            if (orgs.isPresent()) {
                for (String oId : (List)orgs.get()) {
                    if (!organizationMap.containsKey(oId)) continue;
                    communitySet.addAll(organizationMap.get(oId));
                }
            }
            if (!communitySet.isEmpty()) {
                ResultCommunityList rcl = new ResultCommunityList();
                rcl.setResultId(rId);
                ArrayList<String> communityList = new ArrayList<String>();
                communityList.addAll(communitySet);
                rcl.setCommunityList(communityList);
                return rcl;
            }
            return null;
        };
    }
}

