/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.bulktag.community;

import com.google.gson.Gson;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ResultTagger
implements Serializable {
    private boolean clearContext(Result result) {
        int tmp = result.getContext().size();
        List clist = result.getContext().stream().filter(c -> !c.getId().contains("zenodo.org/communities/")).collect(Collectors.toList());
        result.setContext(clist);
        return tmp != clist.size();
    }

    private Map<String, List<String>> getParamMap(Result result, Map<String, String> params) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        String json = new Gson().toJson((Object)result, Result.class);
        DocumentContext jsonContext = JsonPath.parse((String)json);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        for (String key : params.keySet()) {
            try {
                param.put(key, (List<String>)jsonContext.read(params.get(key), new Predicate[0]));
            }
            catch (PathNotFoundException e) {
                param.put(key, new ArrayList());
            }
        }
        return param;
    }

    public <R extends Result> R enrichContextCriteria(R result, CommunityConfiguration conf, Map<String, String> criteria) {
        Map<String, List<String>> param = this.getParamMap(result, criteria);
        if (result.getDataInfo().getDeletedbyinference().booleanValue()) {
            this.clearContext(result);
            return result;
        }
        HashSet communities = new HashSet();
        HashSet subjects = new HashSet();
        if (Objects.nonNull(result.getSubject())) {
            result.getSubject().stream().map(StructuredProperty::getValue).filter(StringUtils::isNotBlank).map(String::toLowerCase).map(String::trim).collect(Collectors.toCollection(HashSet::new)).forEach(s -> subjects.addAll(conf.getCommunityForSubjectValue((String)s)));
        }
        communities.addAll(subjects);
        HashSet datasources = new HashSet();
        HashSet<String> tmp = new HashSet<String>();
        if (Objects.nonNull(result.getInstance())) {
            for (Instance i : result.getInstance()) {
                if (Objects.nonNull(i.getCollectedfrom()) && Objects.nonNull(i.getCollectedfrom().getKey())) {
                    tmp.add(StringUtils.substringAfter((String)i.getCollectedfrom().getKey(), (String)"|"));
                }
                if (!Objects.nonNull(i.getHostedby()) || !Objects.nonNull(i.getHostedby().getKey())) continue;
                tmp.add(StringUtils.substringAfter((String)i.getHostedby().getKey(), (String)"|"));
            }
            tmp.forEach(dsId -> datasources.addAll(conf.getCommunityForDatasource((String)dsId, param)));
        }
        communities.addAll(datasources);
        HashSet czenodo = new HashSet();
        Optional<List> oresultcontext = Optional.ofNullable(result.getContext());
        if (oresultcontext.isPresent()) {
            oresultcontext.get().stream().filter(c -> c.getId().contains("zenodo.org/communities/")).collect(Collectors.toList()).forEach(c -> czenodo.addAll(conf.getCommunityForZenodoCommunityValue(c.getId().substring(c.getId().lastIndexOf("/") + 1).trim())));
        }
        communities.addAll(czenodo);
        this.clearContext(result);
        if (communities.isEmpty()) {
            return result;
        }
        result.getContext().forEach(c -> {
            if (communities.contains(c.getId())) {
                ArrayList<DataInfo> dataInfoList;
                Optional<List> opt_dataInfoList = Optional.ofNullable(c.getDataInfo());
                if (opt_dataInfoList.isPresent()) {
                    dataInfoList = opt_dataInfoList.get();
                } else {
                    dataInfoList = new ArrayList<DataInfo>();
                    c.setDataInfo(dataInfoList);
                }
                if (subjects.contains(c.getId())) {
                    dataInfoList.add(ResultTagger.getDataInfo("bulktagging", "community:subject", "Bulktagging for Community - Subject", "0.8"));
                }
                if (datasources.contains(c.getId())) {
                    dataInfoList.add(ResultTagger.getDataInfo("bulktagging", "community:datasource", "Bulktagging for Community - Datasource", "0.8"));
                }
                if (czenodo.contains(c.getId())) {
                    dataInfoList.add(ResultTagger.getDataInfo("bulktagging", "community:zenodocommunity", "Bulktagging for Community - Zenodo", "0.8"));
                }
            }
        });
        communities.removeAll(result.getContext().stream().map(Context::getId).collect(Collectors.toSet()));
        if (communities.isEmpty()) {
            return result;
        }
        List toaddcontext = communities.stream().map(c -> {
            Context context = new Context();
            context.setId(c);
            ArrayList<DataInfo> dataInfoList = new ArrayList<DataInfo>();
            if (subjects.contains(c)) {
                dataInfoList.add(ResultTagger.getDataInfo("bulktagging", "community:subject", "Bulktagging for Community - Subject", "0.8"));
            }
            if (datasources.contains(c)) {
                dataInfoList.add(ResultTagger.getDataInfo("bulktagging", "community:datasource", "Bulktagging for Community - Datasource", "0.8"));
            }
            if (czenodo.contains(c)) {
                dataInfoList.add(ResultTagger.getDataInfo("bulktagging", "community:zenodocommunity", "Bulktagging for Community - Zenodo", "0.8"));
            }
            context.setDataInfo(dataInfoList);
            return context;
        }).collect(Collectors.toList());
        result.getContext().addAll(toaddcontext);
        return result;
    }

    public static DataInfo getDataInfo(String inference_provenance, String inference_class_id, String inference_class_name, String trust) {
        DataInfo di = new DataInfo();
        di.setInferred(Boolean.valueOf(true));
        di.setInferenceprovenance(inference_provenance);
        di.setProvenanceaction(ResultTagger.getQualifier(inference_class_id, inference_class_name));
        di.setTrust(trust);
        return di;
    }

    public static Qualifier getQualifier(String inference_class_id, String inference_class_name) {
        Qualifier pa = new Qualifier();
        pa.setClassid(inference_class_id);
        pa.setClassname(inference_class_name);
        pa.setSchemeid("dnet:provenanceActions");
        pa.setSchemename("dnet:provenanceActions");
        return pa;
    }
}

