/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.countrypropagation;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.countrypropagation.CountrySbs;
import eu.dnetlib.dhp.countrypropagation.DatasourceCountry;
import eu.dnetlib.dhp.countrypropagation.EntityEntityRel;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareDatasourceCountryAssociation {
    private static final Logger log = LoggerFactory.getLogger(PrepareDatasourceCountryAssociation.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareDatasourceCountryAssociation.class.getResourceAsStream("/eu/dnetlib/dhp/countrypropagation/input_prepareassoc_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareDatasourceCountryAssociation.prepareDatasourceCountryAssociation(spark, Arrays.asList(parser.get("whitelist").split(";")), Arrays.asList(parser.get("allowedtypes").split(";")), inputPath, outputPath);
        });
    }

    private static void prepareDatasourceCountryAssociation(SparkSession spark, List<String> whitelist, List<String> allowedtypes, String inputPath, String outputPath) {
        Dataset datasource = PropagationConstant.readPath(spark, inputPath + "/datasource", Datasource.class).filter((FilterFunction & Serializable)ds -> ds.getDataInfo().getDeletedbyinference() == false && (allowedtypes.contains(ds.getDatasourcetype().getClassid()) || whitelist.contains(ds.getId())));
        Dataset relation = PropagationConstant.readPath(spark, inputPath + "/relation", Relation.class).filter((FilterFunction & Serializable)rel -> rel.getRelClass().equalsIgnoreCase("isProvidedBy") && rel.getDataInfo().getDeletedbyinference() == false);
        Dataset organization = PropagationConstant.readPath(spark, inputPath + "/organization", Organization.class).filter((FilterFunction & Serializable)o -> o.getDataInfo().getDeletedbyinference() == false && o.getCountry().getClassid().length() > 0 && !o.getCountry().getClassid().equals("UNKNOWN"));
        Dataset dse = datasource.joinWith(relation, datasource.col("id").equalTo((Object)relation.col("source"))).map((MapFunction & Serializable)t2 -> EntityEntityRel.newInstance(((Relation)t2._2).getSource(), ((Relation)t2._2).getTarget()), Encoders.bean(EntityEntityRel.class));
        dse.joinWith(organization, dse.col("entity2Id").equalTo((Object)organization.col("id"))).map((MapFunction & Serializable)t2 -> {
            Qualifier country = ((Organization)t2._2).getCountry();
            return DatasourceCountry.newInstance(((EntityEntityRel)t2._1).getEntity1Id(), CountrySbs.newInstance(country.getClassid(), country.getClassname()));
        }, Encoders.bean(DatasourceCountry.class)).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(outputPath);
    }
}

