/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttoorganizationfrominstrepo;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.KeyValueSet;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttoorganizationfrominstrepo.DatasourceOrganization;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResultInstRepoAssociation {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultInstRepoAssociation.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultInstRepoAssociation.class.getResourceAsStream("/eu/dnetlib/dhp/resulttoorganizationfrominstrepo/input_prepareresultorg_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String datasourceOrganizationPath = parser.get("datasourceOrganizationPath");
        log.info("datasourceOrganizationPath {}: ", (Object)datasourceOrganizationPath);
        String alreadyLinkedPath = parser.get("alreadyLinkedPath");
        log.info("alreadyLinkedPath {}: ", (Object)alreadyLinkedPath);
        List blacklist = Optional.ofNullable(parser.get("blacklist")).map(v -> Arrays.asList(v.split(";"))).orElse(new ArrayList());
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PrepareResultInstRepoAssociation.readNeededResources(spark, inputPath);
            PropagationConstant.removeOutputDir(spark, datasourceOrganizationPath);
            PrepareResultInstRepoAssociation.prepareDatasourceOrganization(spark, datasourceOrganizationPath, blacklist);
            PropagationConstant.removeOutputDir(spark, alreadyLinkedPath);
            PrepareResultInstRepoAssociation.prepareAlreadyLinkedAssociation(spark, alreadyLinkedPath);
        });
    }

    private static void readNeededResources(SparkSession spark, String inputPath) {
        Dataset<Datasource> datasource = PropagationConstant.readPath(spark, inputPath + "/datasource", Datasource.class);
        datasource.createOrReplaceTempView("datasource");
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputPath + "/relation", Relation.class);
        relation.createOrReplaceTempView("relation");
        Dataset<Organization> organization = PropagationConstant.readPath(spark, inputPath + "/organization", Organization.class);
        organization.createOrReplaceTempView("organization");
    }

    private static void prepareDatasourceOrganization(SparkSession spark, String datasourceOrganizationPath, List<String> blacklist) {
        String blacklisted = blacklist.stream().map(s -> " AND id != '" + s + "'").collect(Collectors.joining());
        String query = "SELECT source datasourceId, target organizationId FROM ( SELECT id FROM datasource WHERE datasourcetype.classid = 'pubsrepository::institutional' AND datainfo.deletedbyinference = false  " + blacklisted + " ) d JOIN ( SELECT source, target FROM relation WHERE lower(relclass) = '" + "isProvidedBy".toLowerCase() + "' AND datainfo.deletedbyinference = false ) rel ON d.id = rel.source ";
        spark.sql(query).as(Encoders.bean(DatasourceOrganization.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(datasourceOrganizationPath);
    }

    private static void prepareAlreadyLinkedAssociation(SparkSession spark, String alreadyLinkedPath) {
        String query = "Select source key, collect_set(target) valueSet from relation where datainfo.deletedbyinference = false and lower(relClass) = '" + "hasAuthorInstitution".toLowerCase() + "' group by source";
        spark.sql(query).as(Encoders.bean(KeyValueSet.class)).toJavaRDD().map((Function & Serializable)r -> OBJECT_MAPPER.writeValueAsString(r)).saveAsTextFile(alreadyLinkedPath, GzipCodec.class);
    }
}

