/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.orcidtoresultfromsemrel;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.AutoritativeAuthor;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.ResultOrcidList;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareResultOrcidAssociationStep2 {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultOrcidAssociationStep2.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultOrcidAssociationStep2.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/orcidtoresultfromsemrel/input_prepareorcidtoresult_parameters2.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareResultOrcidAssociationStep2.mergeInfo(spark, inputPath, outputPath);
        });
    }

    private static void mergeInfo(SparkSession spark, String inputPath, String outputPath) {
        Dataset resultOrcidAssoc = PropagationConstant.readPath(spark, inputPath + "/publication", ResultOrcidList.class).union(PropagationConstant.readPath(spark, inputPath + "/dataset", ResultOrcidList.class)).union(PropagationConstant.readPath(spark, inputPath + "/otherresearchproduct", ResultOrcidList.class)).union(PropagationConstant.readPath(spark, inputPath + "/software", ResultOrcidList.class));
        resultOrcidAssoc.toJavaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getResultId(), r)).reduceByKey((Function2 & Serializable)(a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            HashSet orcid_set = new HashSet();
            a.getAuthorList().stream().forEach(aa -> orcid_set.add(aa.getOrcid()));
            b.getAuthorList().stream().forEach(aa -> {
                if (!orcid_set.contains(aa.getOrcid())) {
                    a.getAuthorList().add((AutoritativeAuthor)aa);
                    orcid_set.add(aa.getOrcid());
                }
            });
            return a;
        }).map(Tuple2::_2).map((Function & Serializable)r -> OBJECT_MAPPER.writeValueAsString(r)).saveAsTextFile(outputPath, GzipCodec.class);
    }
}

