/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttoorganizationfrominstrepo;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendNewRelations
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AppendNewRelations.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)AppendNewRelations.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/resulttoorganizationfrominstrepo/input_newrelation_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> AppendNewRelations.appendNewRelation(spark, inputPath, outputPath));
    }

    private static void appendNewRelation(SparkSession spark, String inputPath, String outputPath) {
        PropagationConstant.readPath(spark, inputPath + "publication/relation", Relation.class).union(PropagationConstant.readPath(spark, inputPath + "dataset/relation", Relation.class)).union(PropagationConstant.readPath(spark, inputPath + "otherresearchproduct/relation", Relation.class)).union(PropagationConstant.readPath(spark, inputPath + "software/relation", Relation.class)).write().mode(SaveMode.Append).option("compression", "gzip").json(outputPath);
    }
}

