/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.orcidtoresultfromsemrel;

import eu.dnetlib.dhp.common.author.SparkEnrichWithOrcidAuthors;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.OrcidAuthors;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.utils.OrcidAuthor;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkPropagateOrcidAuthor
extends SparkEnrichWithOrcidAuthors {
    private static final Logger log = LoggerFactory.getLogger(SparkPropagateOrcidAuthor.class);

    public SparkPropagateOrcidAuthor(String propertyPath, String[] args, Logger log) {
        super(propertyPath, args, log);
    }

    public static void main(String[] args) throws Exception {
        SparkPropagateOrcidAuthor app = new SparkPropagateOrcidAuthor("/eu/dnetlib/dhp/wf/subworkflows/orcidtoresultfromsemrel/input_orcidtoresult_parameters.json", args, log);
        app.initialize().run();
    }

    private static OrcidAuthors getOrcidAuthorsList(List<Author> authors) {
        OrcidAuthors oas = new OrcidAuthors();
        List<OrcidAuthor> tmp = authors.stream().map(SparkPropagateOrcidAuthor::getOrcidAuthor).filter(Objects::nonNull).collect(Collectors.toList());
        oas.setOrcidAuthorList(tmp);
        return oas;
    }

    private static OrcidAuthor getOrcidAuthor(Author a) {
        return Optional.ofNullable(SparkPropagateOrcidAuthor.getOrcid(a)).map(orcid -> new OrcidAuthor(orcid, a.getSurname(), a.getName(), a.getFullname(), null)).orElse(null);
    }

    private static String getOrcid(Author a) {
        if (a.getPid().stream().anyMatch(p -> p.getQualifier().getClassid().equalsIgnoreCase("orcid"))) {
            return a.getPid().stream().filter(p -> p.getQualifier().getClassid().equalsIgnoreCase("orcid")).findFirst().get().getValue();
        }
        if (a.getPid().stream().anyMatch(p -> p.getQualifier().getClassid().equalsIgnoreCase("orcid_pending"))) {
            return a.getPid().stream().filter(p -> p.getQualifier().getClassid().equalsIgnoreCase("orcid_pending")).findFirst().get().getValue();
        }
        return null;
    }

    public void createTemporaryData(SparkSession spark, String graphPath, String orcidPath, String targetPath) {
        ModelSupport.entityTypes.keySet().stream().filter(ModelSupport::isResult).forEach(e -> {
            Dataset orcidDnet = spark.read().schema(Encoders.bean(Result.class).schema()).json(graphPath + "/" + e.name()).as(Encoders.bean(Result.class)).filter((FilterFunction & Serializable)r -> r.getAuthor() != null && r.getAuthor().stream().anyMatch(a -> a.getPid() != null && a.getPid().stream().anyMatch(p -> p.getQualifier().getClassid().equalsIgnoreCase("orcid") || p.getQualifier().getClassid().equalsIgnoreCase("orcid_pending")))).map((MapFunction & Serializable)r -> new Tuple2((Object)r.getId(), (Object)SparkPropagateOrcidAuthor.getOrcidAuthorsList(r.getAuthor())), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.bean(OrcidAuthors.class))).selectExpr(new String[]{"_1 as target", "_2.orcidAuthorList as orcid_authors"});
            Dataset result = spark.read().schema(Encoders.bean(Result.class).schema()).json(graphPath + "/" + e.name()).as(Encoders.bean(Result.class)).selectExpr(new String[]{"id", "author as graph_authors"});
            Dataset supplements = spark.read().schema(Encoders.bean(Relation.class).schema()).json(graphPath + "/relation").where("relclass IN('IsSupplementTo', 'IsSupplementedBy')").selectExpr(new String[]{"source as id", "target"});
            result.join(supplements, "id").join(orcidDnet, "target").drop("target").write().mode(SaveMode.Overwrite).option("compression", "gzip").parquet(targetPath + "/" + e.name() + "_unmatched");
        });
    }
}

