/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.personprojectthroughdeliverable;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.personprojectthroughdeliverable.SparkAuthorProjectRelationExtraction;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonProjectPropagationJobTest {
    private static final Logger log = LoggerFactory.getLogger(PersonProjectPropagationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PersonProjectPropagationJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PersonProjectPropagationJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PersonProjectPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void projectAuthorRelationTestDeliverableOnly() throws Exception {
        SparkAuthorProjectRelationExtraction.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-workingDir", workingDir.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/person/projectrelsextraction/graph").getPath(), "-classCodes", "0034"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)2L, (long)relations.count());
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"40|aka_________::4892912a1a2c54a98fa85bb08afc2a32", (Object)relation.getTarget()));
        Assertions.assertTrue((relations.filter((FilterFunction & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::bc79e7b6b0e339357634105055d5f29c")).count() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((relations.filter((FilterFunction & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::61fea345f34b5166d4afbe9e98fcbe4f")).count() > 0L ? 1 : 0) != 0);
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"projectPerson", (Object)relation.getRelType()));
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"participation", (Object)relation.getSubRelType()));
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"participatesToProject", (Object)relation.getRelClass()));
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
    }

    @Test
    void projectAuthorRelationTest() throws Exception {
        SparkAuthorProjectRelationExtraction.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-workingDir", workingDir.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/person/projectrelsextraction/graph").getPath(), "-classCodes", "0034;0017"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)3L, (long)relations.count());
        Assertions.assertEquals((long)2L, (long)relations.filter((FilterFunction & Serializable)relation -> relation.getTarget().equalsIgnoreCase("40|aka_________::4892912a1a2c54a98fa85bb08afc2a32")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)relation -> relation.getTarget().equalsIgnoreCase("40|aka_________::08271906a58b12101a2413c4eeaffe98")).count());
        Assertions.assertTrue((relations.filter((FilterFunction & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::bc79e7b6b0e339357634105055d5f29c")).count() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((relations.filter((FilterFunction & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::61fea345f34b5166d4afbe9e98fcbe4f")).count() > 0L ? 1 : 0) != 0);
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"projectPerson", (Object)relation.getRelType()));
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"participation", (Object)relation.getSubRelType()));
        relations.foreach((ForeachFunction & Serializable)relation -> Assertions.assertEquals((Object)"participatesToProject", (Object)relation.getRelClass()));
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
    }
}

