/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.api.QueryCommunityAPI;
import eu.dnetlib.dhp.api.model.CommonConfigurationModel;
import eu.dnetlib.dhp.api.model.CommunityContentprovider;
import eu.dnetlib.dhp.api.model.CommunityEntityMap;
import eu.dnetlib.dhp.api.model.CommunityModel;
import eu.dnetlib.dhp.api.model.ContentModel;
import eu.dnetlib.dhp.api.model.DatasourceList;
import eu.dnetlib.dhp.api.model.EntityList;
import eu.dnetlib.dhp.api.model.SubCommunityModel;
import eu.dnetlib.dhp.bulktag.SparkBulkTagJob;
import eu.dnetlib.dhp.bulktag.community.Community;
import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.bulktag.community.Provider;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolver;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolverFactory;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Project;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils
implements Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final VerbResolver resolver = VerbResolverFactory.newInstance();
    private static final Logger log = LoggerFactory.getLogger(SparkBulkTagJob.class);

    public static CommunityEntityMap getProjectCommunityMap(String baseURL) throws IOException {
        CommunityEntityMap projectMap = new CommunityEntityMap();
        Utils.getValidCommunities(baseURL).forEach(community -> {
            Utils.addRelevantProjects(community.getId(), baseURL, projectMap);
            try {
                List<SubCommunityModel> subcommunities = Utils.getSubcommunities(community.getId(), baseURL);
                subcommunities.forEach(sc -> Utils.addRelevantProjects(community.getId(), sc.getSubCommunityId(), baseURL, projectMap));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return projectMap;
    }

    private static void addRelevantProjects(String communityId, String baseURL, CommunityEntityMap communityEntityMap) {
        Utils.fetchAndProcessProjects((page, size) -> {
            try {
                return QueryCommunityAPI.communityProjects(communityId, String.valueOf(page), String.valueOf(size), baseURL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, communityId, communityEntityMap);
    }

    private static void addRelevantProjects(String communityId, String subcommunityId, String baseURL, CommunityEntityMap communityEntityMap) {
        Utils.fetchAndProcessProjects((page, size) -> {
            try {
                return QueryCommunityAPI.subcommunityProjects(communityId, subcommunityId, String.valueOf(page), String.valueOf(size), baseURL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, communityId, communityEntityMap);
    }

    private static void fetchAndProcessProjects(ProjectQueryFunction projectQueryFunction, String communityId, CommunityEntityMap communityEntityMap) {
        ContentModel contentModel;
        int page = 0;
        int size = 100;
        do {
            try {
                String response = projectQueryFunction.query(page, 100);
                contentModel = (ContentModel)MAPPER.readValue(response, ContentModel.class);
                if (!contentModel.getContent().isEmpty()) {
                    contentModel.getContent().forEach(project -> communityEntityMap.add(ModelSupport.getIdPrefix(Project.class) + "|" + project.getOpenaireId(), communityId));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error processing projects for community: " + communityId, e);
            }
            ++page;
        } while (!contentModel.getLast().booleanValue());
    }

    private static List<Provider> getCommunityContentProviders(DatasourceQueryFunction datasourceQueryFunction) {
        try {
            String response = datasourceQueryFunction.query();
            List datasourceList = (List)MAPPER.readValue(response, (TypeReference)new TypeReference<List<CommunityContentprovider>>(){});
            return datasourceList.stream().map(d -> {
                if (d.getEnabled() == null || Boolean.FALSE.equals(d.getEnabled())) {
                    return null;
                }
                Provider p = new Provider();
                p.setOpenaireId(ModelSupport.getIdPrefix(Datasource.class) + "|" + d.getOpenaireId());
                p.setSelectionConstraints(d.getSelectioncriteria());
                if (p.getSelectionConstraints() != null) {
                    p.getSelectionConstraints().setSelection(resolver);
                }
                return p;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Error processing datasource information: " + String.valueOf(e));
        }
    }

    public static List<CommunityModel> getValidCommunities(String baseURL) throws IOException {
        List listCommunity = (List)MAPPER.readValue(QueryCommunityAPI.communities(baseURL), (TypeReference)new TypeReference<List<CommunityModel>>(){});
        return listCommunity.stream().filter(community -> !community.getStatus().equals("hidden") && (community.getType().equals("ri") || community.getType().equals("community"))).collect(Collectors.toList());
    }

    private static Community getCommunity(String baseURL, CommunityModel communityModel) {
        log.info("getting community {}", (Object)communityModel.getId());
        try {
            Community community = Utils.getCommunity((CommunityModel)MAPPER.readValue(QueryCommunityAPI.community(communityModel.getId(), baseURL), CommunityModel.class));
            String id = community.getId();
            community.setProviders(Utils.getCommunityContentProviders(() -> {
                try {
                    return QueryCommunityAPI.communityDatasource(id, baseURL);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            return community;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @NotNull
    private static Community getSubCommunityConfiguration(String baseURL, String communityId, SubCommunityModel sc) {
        Community c = Utils.getCommunity(sc);
        c.setProviders(Utils.getCommunityContentProviders(() -> {
            try {
                return QueryCommunityAPI.subcommunityDatasource(communityId, sc.getSubCommunityId(), baseURL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return c;
    }

    private static List<Community> getSubCommunity(String communityId, String baseURL) {
        try {
            List<SubCommunityModel> subcommunities = Utils.getSubcommunities(communityId, baseURL);
            return subcommunities.stream().map(sc -> Utils.getSubCommunityConfiguration(baseURL, communityId, sc)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CommunityConfiguration getCommunityConfiguration(String baseURL) throws IOException {
        HashMap communities = Maps.newHashMap();
        List<CommunityModel> communityList = Utils.getValidCommunities(baseURL);
        ArrayList validCommunities = new ArrayList();
        communityList.forEach(community -> {
            validCommunities.add(Utils.getCommunity(baseURL, community));
            validCommunities.addAll(Utils.getSubCommunity(community.getId(), baseURL));
        });
        validCommunities.forEach(community -> {
            if (community.isValid()) {
                communities.put(community.getId(), community);
            }
        });
        return new CommunityConfiguration(communities);
    }

    private static <C extends CommonConfigurationModel> Community getCommonConfiguration(C input) {
        Community c = new Community();
        c.setZenodoCommunities(input.getOtherZenodoCommunities());
        if (StringUtils.isNotBlank((CharSequence)input.getZenodoCommunity())) {
            c.getZenodoCommunities().add(input.getZenodoCommunity());
        }
        c.setSubjects(input.getSubjects());
        if (input.getFos() != null) {
            c.getSubjects().addAll(input.getFos());
        }
        if (input.getSdg() != null) {
            c.getSubjects().addAll(input.getSdg());
        }
        if (input.getAdvancedConstraints() != null) {
            c.setConstraints(input.getAdvancedConstraints());
            c.getConstraints().setSelection(resolver);
        }
        if (input.getRemoveConstraints() != null) {
            c.setRemoveConstraints(input.getRemoveConstraints());
            c.getRemoveConstraints().setSelection(resolver);
        }
        return c;
    }

    private static Community getCommunity(SubCommunityModel sc) {
        Community c = Utils.getCommonConfiguration(sc);
        c.setId(sc.getSubCommunityId());
        return c;
    }

    private static Community getCommunity(CommunityModel cm) {
        Community c = Utils.getCommonConfiguration(cm);
        c.setId(cm.getId());
        return c;
    }

    public static List<SubCommunityModel> getSubcommunities(String communityId, String baseURL) throws IOException {
        return (List)MAPPER.readValue(QueryCommunityAPI.subcommunities(communityId, baseURL), (TypeReference)new TypeReference<List<SubCommunityModel>>(){});
    }

    public static CommunityEntityMap getOrganizationCommunityMap(String baseURL) throws IOException {
        return Utils.addPrefixToKey(ModelSupport.getIdPrefix(Organization.class) + "|", (CommunityEntityMap)MAPPER.readValue(QueryCommunityAPI.propagationOrganizationCommunityMap(baseURL), CommunityEntityMap.class));
    }

    private static CommunityEntityMap addPrefixToKey(String prefix, CommunityEntityMap communityEntityMap) {
        CommunityEntityMap cem = new CommunityEntityMap();
        Set keySet = communityEntityMap.keySet();
        for (String key : keySet) {
            cem.put(prefix + key, communityEntityMap.get(key));
        }
        return cem;
    }

    public static CommunityEntityMap getDatasourceCommunityMap(String baseURL) throws IOException {
        return Utils.addPrefixToKey(ModelSupport.getIdPrefix(Datasource.class) + "|", (CommunityEntityMap)MAPPER.readValue(QueryCommunityAPI.propagationDatasourceCommunityMap(baseURL), CommunityEntityMap.class));
    }

    public static CommunityEntityMap getDatasourceCommunities(String baseURL) throws IOException {
        List<CommunityModel> validCommunities = Utils.getValidCommunities(baseURL);
        HashMap map = new HashMap();
        validCommunities.forEach(c -> {
            try {
                Utils.addDatasources(c.getId(), QueryCommunityAPI.communityDatasource(c.getId(), baseURL), map);
                Utils.getSubcommunities(c.getId(), baseURL).forEach(sc -> {
                    try {
                        Utils.addDatasources(sc.getSubCommunityId(), QueryCommunityAPI.subcommunityDatasource(c.getId(), sc.getSubCommunityId(), baseURL), map);
                    }
                    catch (IOException ioException) {
                        throw new RuntimeException();
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        });
        String prefix = ModelSupport.getIdPrefix(Datasource.class) + "|";
        CommunityEntityMap cem = new CommunityEntityMap();
        map.keySet().forEach(k -> cem.put(prefix + k, Utils.getCollect(k, map)));
        return cem;
    }

    private static void addDatasources(String communityId, String dsl, HashMap<String, Set<String>> map) throws IOException {
        ((DatasourceList)new ObjectMapper().readValue(dsl, DatasourceList.class)).forEach(d -> {
            if (!map.keySet().contains(d.getOpenaireId())) {
                map.put(d.getOpenaireId(), new HashSet());
            }
            ((Set)map.get(d.getOpenaireId())).add(communityId);
        });
    }

    @NotNull
    private static List<String> getCollect(String k, HashMap<String, Set<String>> map) {
        List<String> temp = map.get(k).stream().collect(Collectors.toList());
        return temp;
    }

    private static void getRelatedOrganizations(String communityId, String baseURL, CommunityEntityMap communityEntityMap) {
        try {
            List associatedOrgs = (List)MAPPER.readValue(QueryCommunityAPI.communityPropagationOrganization(communityId, baseURL), EntityList.class);
            associatedOrgs.forEach(o -> communityEntityMap.add(ModelSupport.getIdPrefix(Organization.class) + "|" + o.getOrgId(), communityId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void getRelatedOrganizations(String communityId, String subcommunityId, String baseURL, CommunityEntityMap communityEntityMap) {
        try {
            List associatedOrgs = (List)MAPPER.readValue(QueryCommunityAPI.subcommunityPropagationOrganization(communityId, subcommunityId, baseURL), EntityList.class);
            associatedOrgs.forEach(o -> communityEntityMap.add(ModelSupport.getIdPrefix(Organization.class) + "|" + o.getOrgId(), communityId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CommunityEntityMap getCommunityOrganization(String baseURL) throws IOException {
        CommunityEntityMap organizationMap = new CommunityEntityMap();
        List<CommunityModel> communityList = Utils.getValidCommunities(baseURL);
        communityList.forEach(community -> {
            Utils.getRelatedOrganizations(community.getId(), baseURL, organizationMap);
            try {
                List<SubCommunityModel> subcommunities = Utils.getSubcommunities(community.getId(), baseURL);
                subcommunities.forEach(sc -> Utils.getRelatedOrganizations(community.getId(), sc.getSubCommunityId(), baseURL, organizationMap));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return organizationMap;
    }

    public static List<String> getCommunityIdList(String baseURL) throws IOException {
        return Utils.getValidCommunities(baseURL).stream().flatMap(communityModel -> {
            ArrayList<String> communityIds = new ArrayList<String>();
            communityIds.add(communityModel.getId());
            try {
                Utils.getSubcommunities(communityModel.getId(), baseURL).forEach(sc -> communityIds.add(sc.getSubCommunityId()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return communityIds.stream();
        }).collect(Collectors.toList());
    }

    @FunctionalInterface
    private static interface ProjectQueryFunction {
        public String query(int var1, int var2);
    }

    @FunctionalInterface
    private static interface DatasourceQueryFunction {
        public String query();
    }
}

