/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.person;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.person.SparkExtractPersonRelationsAndAddIndicators;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonPropagationJobTest {
    private static final Logger log = LoggerFactory.getLogger(PersonPropagationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PersonPropagationJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PersonPropagationJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PersonPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testPersonPropagation() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/person/graph").getPath();
        spark.read().json(sourcePath + "/publication").write().json(workingDir.toString() + "/graph/publication");
        spark.read().json(sourcePath + "/dataset").write().json(workingDir.toString() + "/graph/dataset");
        spark.read().json(sourcePath + "/software").write().json(workingDir.toString() + "/graph/software");
        spark.read().json(sourcePath + "/otherresearchproduct").write().json(workingDir.toString() + "/graph/otherresearchproduct");
        spark.read().json(sourcePath + "/person").write().json(workingDir.toString() + "/graph/person");
        spark.read().json(sourcePath + "/relation").write().json(workingDir.toString() + "/graph/relation");
        SparkExtractPersonRelationsAndAddIndicators.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", workingDir.toString() + "/graph", "--outputPath", workingDir.toString() + "/working"});
        Dataset relations = spark.read().schema(Encoders.bean(Relation.class).schema()).json(workingDir.toString() + "/graph/relation").as(Encoders.bean(Relation.class));
        Assertions.assertEquals((long)44L, (long)relations.count());
        Assertions.assertEquals((long)12L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored")).foreach((ForeachFunction & Serializable)r -> Assertions.assertTrue((boolean)r.getSource().startsWith("30|orcid")));
        relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored")).foreach((ForeachFunction & Serializable)r -> Assertions.assertTrue((boolean)r.getTarget().startsWith("50|")));
        Assertions.assertEquals((long)1L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().equalsIgnoreCase("50|doi_________::4892912a1a2c54a98fa85bb08afc2a32")).count());
        Assertions.assertEquals((long)2L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().equalsIgnoreCase("50|doi_________::6ad85dd3c2dcc551912362b6e6c6c87a")).count());
        Assertions.assertEquals((long)4L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hascoauthor") && r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618"))).count());
        Assertions.assertEquals((long)4L, (long)relations.filter((FilterFunction & Serializable)r -> r.getRelClass().equalsIgnoreCase("hascoauthor") && r.getTarget().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618"))).count());
        Dataset person = spark.read().schema(Encoders.bean(Person.class).schema()).json(workingDir.toString() + "/graph/person").as(Encoders.bean(Person.class));
        Assertions.assertEquals((long)8L, (long)person.count());
        Assertions.assertEquals((long)3L, (long)person.filter((FilterFunction & Serializable)p -> p.getMeasures() != null && !p.getMeasures().isEmpty()).count());
        List measures = ((Person)person.filter((FilterFunction & Serializable)p -> p.getId().equals("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3618"))).first()).getMeasures();
        measures.forEach(m -> {
            if (m.getId().equalsIgnoreCase("downloads")) {
                Assertions.assertEquals((Object)"30", (Object)((KeyValue)m.getUnit().get(0)).getValue());
            } else {
                Assertions.assertEquals((Object)"9", (Object)((KeyValue)m.getUnit().get(0)).getValue());
            }
        });
        measures = ((Person)person.filter((FilterFunction & Serializable)p -> p.getId().equals("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3619"))).first()).getMeasures();
        measures.forEach(m -> {
            if (m.getId().equalsIgnoreCase("downloads")) {
                Assertions.assertEquals((Object)"10", (Object)((KeyValue)m.getUnit().get(0)).getValue());
            } else {
                Assertions.assertEquals((Object)"3", (Object)((KeyValue)m.getUnit().get(0)).getValue());
            }
        });
        measures = ((Person)person.filter((FilterFunction & Serializable)p -> p.getId().equals("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-8255-3620"))).first()).getMeasures();
        measures.forEach(m -> {
            if (m.getId().equalsIgnoreCase("downloads")) {
                Assertions.assertEquals((Object)"10", (Object)((KeyValue)m.getUnit().get(0)).getValue());
            } else {
                Assertions.assertEquals((Object)"3", (Object)((KeyValue)m.getUnit().get(0)).getValue());
            }
        });
    }
}

