/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttocommunityfromproject;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.api.Utils;
import eu.dnetlib.dhp.api.model.CommunityEntityMap;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttocommunityfromproject.ResultProjectList;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResultCommunitySet {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultCommunitySet.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultCommunitySet.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/resulttocommunityfromproject/input_preparecommunitytoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String baseURL = parser.get("baseURL");
        log.info("baseURL: {}", (Object)baseURL);
        CommunityEntityMap projectsMap = Utils.getProjectCommunityMap(baseURL);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PropagationConstant.removeOutputDir(spark, outputPath);
            PrepareResultCommunitySet.prepareInfo(spark, inputPath, outputPath, projectsMap);
        });
    }

    private static void prepareInfo(SparkSession spark, String inputPath, String outputPath, CommunityEntityMap projectMap) {
        StructType structureSchema = new StructType().add("dataInfo", (DataType)new StructType().add("deletedbyinference", DataTypes.BooleanType).add("invisible", DataTypes.BooleanType)).add("source", DataTypes.StringType).add("target", DataTypes.StringType).add("relClass", DataTypes.StringType);
        spark.read().schema(structureSchema).json(inputPath).filter("dataInfo.deletedbyinference != true and relClass == 'isProducedBy'").select(new Column[]{new Column("source").as("resultId"), new Column("target").as("projectId")}).groupByKey((MapFunction & Serializable)r -> (String)r.getAs("resultId"), Encoders.STRING()).mapGroups((MapGroupsFunction & Serializable)(k, v) -> {
            ResultProjectList rpl = new ResultProjectList();
            rpl.setResultId((String)k);
            ArrayList<String> cl = new ArrayList<String>();
            cl.addAll(projectMap.get((String)((Row)v.next()).getAs("projectId")));
            v.forEachRemaining(r -> projectMap.get((String)r.getAs("projectId")).forEach(c -> {
                if (!cl.contains(c)) {
                    cl.add((String)c);
                }
            }));
            if (cl.size() == 0) {
                return null;
            }
            rpl.setCommunityList(cl);
            return rpl;
        }, Encoders.bean(ResultProjectList.class)).filter(Objects::nonNull).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }
}

