/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.enrich.relsfrompublisherenricheddata;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.countrypropagation.SparkCountryPropagationJob;
import eu.dnetlib.dhp.utils.ORCIDAuthorEnricherResult;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCopyEnrichedPublisherAuthors
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SparkCountryPropagationJob.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)SparkCopyEnrichedPublisherAuthors.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/enrich/publisher/input_propagation_parameter.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> SparkCopyEnrichedPublisherAuthors.copyEnrichedAuthors(spark, workingDir, outputPath));
    }

    private static void copyEnrichedAuthors(SparkSession spark, String workingDir, String persistedPath) {
        spark.read().schema(Encoders.bean(ORCIDAuthorEnricherResult.class).schema()).parquet(workingDir + "/publication_matched").selectExpr(new String[]{"id as doi", "enriched_author"}).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(persistedPath + "/publisherEnrichedAuthors");
    }
}

