/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.entitytoorganizationfromsemrel;

import eu.dnetlib.dhp.KeyValueSet;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttoorganizationfrominstrepo.SparkResultToOrganizationFromIstRepoJob;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PrepareInfo.class);
    private static final String ORGANIZATION_ORGANIZATION_QUERY = "SELECT target key, collect_set(source) as valueSet FROM relation WHERE lower(relclass) = '" + "IsParentOf".toLowerCase() + "' and datainfo.deletedbyinference = false GROUP BY target";
    private static final String RESULT_ORGANIZATION_QUERY = "SELECT source key, collect_set(target) as valueSet FROM relation WHERE lower(relclass) = '" + "hasAuthorInstitution".toLowerCase() + "' and datainfo.deletedbyinference = false GROUP BY source";
    private static final String PROJECT_ORGANIZATION_QUERY = "SELECT source key, collect_set(target) as valueSet FROM relation WHERE lower(relclass) = '" + "hasParticipant".toLowerCase() + "' and datainfo.deletedbyinference = false GROUP BY source";

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)SparkResultToOrganizationFromIstRepoJob.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/entitytoorganizationfromsemrel/input_preparation_parameter.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String leavesPath = parser.get("leavesPath");
        log.info("leavesPath: {}", (Object)leavesPath);
        String childParentPath = parser.get("childParentPath");
        log.info("childParentPath: {}", (Object)childParentPath);
        String resultOrganizationPath = parser.get("resultOrgPath");
        log.info("resultOrganizationPath: {}", (Object)resultOrganizationPath);
        String projectOrgPath = parser.get("projectOrganizationPath");
        log.info("projectOrgPath: {}", (Object)projectOrgPath);
        String relationPath = parser.get("relationPath");
        log.info("relationPath: {}", (Object)relationPath);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> PrepareInfo.prepareInfo(spark, graphPath, childParentPath, leavesPath, resultOrganizationPath, projectOrgPath, relationPath));
    }

    private static void prepareInfo(SparkSession spark, String inputPath, String childParentOrganizationPath, String currentIterationPath, String resultOrganizationPath, String projectOrganizationPath, String relationPath) {
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputPath + "/relation", Relation.class);
        relation.createOrReplaceTempView("relation");
        spark.sql(ORGANIZATION_ORGANIZATION_QUERY).as(Encoders.bean(KeyValueSet.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(childParentOrganizationPath);
        spark.sql(RESULT_ORGANIZATION_QUERY).as(Encoders.bean(KeyValueSet.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(resultOrganizationPath);
        spark.sql(PROJECT_ORGANIZATION_QUERY).as(Encoders.bean(KeyValueSet.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(projectOrganizationPath);
        relation.filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference() == false && r.getRelClass().equals("hasAuthorInstitution")).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(relationPath + "/result");
        relation.filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference() == false && r.getRelClass().equals("hasParticipant")).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(relationPath + "/project");
        Dataset children = spark.sql("Select distinct target as child from relation where lower(relclass)='" + "IsParentOf".toLowerCase() + "' and datainfo.deletedbyinference = false").as(Encoders.STRING());
        Dataset parent = spark.sql("Select distinct source as parent from relation where lower(relclass)='" + "IsParentOf".toLowerCase() + "' and datainfo.deletedbyinference = false").as(Encoders.STRING());
        children.joinWith(parent, children.col("child").equalTo((Object)parent.col("parent")), "left").map((MapFunction & Serializable)value -> {
            if (Optional.ofNullable((String)value._2()).isPresent()) {
                return null;
            }
            return (String)value._1();
        }, Encoders.STRING()).filter(Objects::nonNull).write().mode(SaveMode.Overwrite).json(currentIterationPath);
    }
}

