/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.projecttoresult;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.projecttoresult.SparkResultToProjectThroughSemRelJob;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropagationJobTest {
    private static final Logger log = LoggerFactory.getLogger(ProjectPropagationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ProjectPropagationJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(ProjectPropagationJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(ProjectPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void NoUpdateTest() throws Exception {
        String potentialUpdateDate = this.getClass().getResource("/eu/dnetlib/dhp/projecttoresult/preparedInfo/noupdates/potentialUpdates").getPath();
        String alreadyLinkedPath = this.getClass().getResource("/eu/dnetlib/dhp/projecttoresult/preparedInfo/alreadyLinked").getPath();
        SparkResultToProjectThroughSemRelJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-hive_metastore_uris", "", "-saveGraph", "true", "-outputPath", workingDir.toString() + "/relation", "-potentialUpdatePath", potentialUpdateDate, "-alreadyLinkedPath", alreadyLinkedPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)0L, (long)tmp.count());
    }

    @Test
    void UpdateTenTest() throws Exception {
        String potentialUpdatePath = this.getClass().getResource("/eu/dnetlib/dhp/projecttoresult/preparedInfo/tenupdates/potentialUpdates").getPath();
        String alreadyLinkedPath = this.getClass().getResource("/eu/dnetlib/dhp/projecttoresult/preparedInfo/alreadyLinked").getPath();
        SparkResultToProjectThroughSemRelJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-hive_metastore_uris", "", "-saveGraph", "true", "-outputPath", workingDir.toString() + "/relation", "-potentialUpdatePath", potentialUpdatePath, "-alreadyLinkedPath", alreadyLinkedPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)10L, (long)tmp.count());
        Dataset verificationDs = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        Assertions.assertEquals((long)5L, (long)verificationDs.filter("relClass = 'produces'").count());
        Assertions.assertEquals((long)5L, (long)verificationDs.filter("relClass = 'isProducedBy'").count());
        Assertions.assertEquals((long)5L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().startsWith("50") && r.getTarget().startsWith("40") && r.getRelClass().equals("isProducedBy")).count());
        Assertions.assertEquals((long)5L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().startsWith("40") && r.getTarget().startsWith("50") && r.getRelClass().equals("produces")).count());
        verificationDs.createOrReplaceTempView("temporary");
        Assertions.assertEquals((long)10L, (long)spark.sql("Select * from temporary where datainfo.inferenceprovenance = 'propagation'").count());
    }

    @Test
    void UpdateMixTest() throws Exception {
        String potentialUpdatepath = this.getClass().getResource("/eu/dnetlib/dhp/projecttoresult/preparedInfo/updatesmixed/potentialUpdates").getPath();
        String alreadyLinkedPath = this.getClass().getResource("/eu/dnetlib/dhp/projecttoresult/preparedInfo/alreadyLinked").getPath();
        SparkResultToProjectThroughSemRelJob.main((String[])new String[]{"-isTest", Boolean.TRUE.toString(), "-isSparkSessionManaged", Boolean.FALSE.toString(), "-hive_metastore_uris", "", "-saveGraph", "true", "-outputPath", workingDir.toString() + "/relation", "-potentialUpdatePath", potentialUpdatepath, "-alreadyLinkedPath", alreadyLinkedPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)8L, (long)tmp.count());
        Dataset verificationDs = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        Assertions.assertEquals((long)4L, (long)verificationDs.filter("relClass = 'produces'").count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter("relClass = 'isProducedBy'").count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().startsWith("50") && r.getTarget().startsWith("40") && r.getRelClass().equals("isProducedBy")).count());
        Assertions.assertEquals((long)4L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().startsWith("40") && r.getTarget().startsWith("50") && r.getRelClass().equals("produces")).count());
        verificationDs.createOrReplaceTempView("temporary");
        Assertions.assertEquals((long)8L, (long)spark.sql("Select * from temporary where datainfo.inferenceprovenance = 'propagation'").count());
    }
}

