/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.graph.GraphMappingUtils;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;

public class SparkGraphImporterJob {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkGraphImporterJob.class.getResourceAsStream("/eu/dnetlib/dhp/graph/input_graph_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkGraphImporterJob.class.getSimpleName()).master(parser.get("master")).config("hive.metastore.uris", parser.get("hive_metastore_uris")).enableHiveSupport().getOrCreate();
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        String inputPath = parser.get("sourcePath");
        String hiveDbName = parser.get("hive_db_name");
        spark.sql(String.format("CREATE DATABASE IF NOT EXISTS %s", hiveDbName));
        GraphMappingUtils.types.forEach((name, clazz) -> spark.createDataset(sc.sequenceFile(inputPath + "/" + name, Text.class, Text.class).map((Function & Serializable)s -> new ObjectMapper().readValue(((Text)s._2()).toString(), clazz)).rdd(), Encoders.bean((Class)clazz)).write().mode(SaveMode.Overwrite).saveAsTable(hiveDbName + "." + name));
    }
}

