/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.DbClient;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.graph.raw.MigrateMongoMdstoresApplication;
import eu.dnetlib.dhp.oa.graph.raw.OafToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.OdfToOafMapper;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class GenerateEntitiesApplication {
    private static final Logger log = LoggerFactory.getLogger(GenerateEntitiesApplication.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/generate_entities_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePaths = parser.get("sourcePaths");
        String targetPath = parser.get("targetPath");
        String dbUrl = parser.get("postgresUrl");
        String dbUser = parser.get("postgresUser");
        String dbPassword = parser.get("postgresPassword");
        Map<String, String> code2name = GenerateEntitiesApplication.loadClassNames(dbUrl, dbUser, dbPassword);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            GenerateEntitiesApplication.removeOutputDir(spark, targetPath);
            GenerateEntitiesApplication.generateEntities(spark, code2name, sourcePaths, targetPath);
        });
    }

    private static void generateEntities(SparkSession spark, Map<String, String> code2name, String sourcePaths, String targetPath) {
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        List<String> existingSourcePaths = Arrays.stream(sourcePaths.split(",")).filter(p -> GenerateEntitiesApplication.exists(sc, p)).collect(Collectors.toList());
        log.info("Generate entities from files:");
        existingSourcePaths.forEach(arg_0 -> ((Logger)log).info(arg_0));
        JavaRDD inputRdd = sc.emptyRDD();
        for (String sp : existingSourcePaths) {
            inputRdd = inputRdd.union(sc.sequenceFile(sp, Text.class, Text.class).map((Function & Serializable)k -> new Tuple2((Object)((Text)k._1()).toString(), (Object)((Text)k._2()).toString())).map((Function & Serializable)k -> GenerateEntitiesApplication.convertToListOaf((String)k._1(), (String)k._2(), code2name)).filter(Objects::nonNull).flatMap((FlatMapFunction & Serializable)list -> list.iterator()));
        }
        inputRdd.mapToPair((PairFunction & Serializable)oaf -> new Tuple2(ModelSupport.idFn().apply(oaf), oaf)).reduceByKey((Function2 & Serializable)(o1, o2) -> GenerateEntitiesApplication.merge(o1, o2)).map(Tuple2::_2).map((Function & Serializable)oaf -> oaf.getClass().getSimpleName().toLowerCase() + "|" + OBJECT_MAPPER.writeValueAsString(oaf)).saveAsTextFile(targetPath, GzipCodec.class);
    }

    private static Oaf merge(Oaf o1, Oaf o2) {
        if (ModelSupport.isSubClass((Oaf)o1, OafEntity.class).booleanValue()) {
            ((OafEntity)o1).mergeFrom((OafEntity)o2);
        } else if (ModelSupport.isSubClass((Oaf)o1, Relation.class).booleanValue()) {
            ((Relation)o1).mergeFrom((Relation)o2);
        } else {
            throw new RuntimeException("invalid Oaf type:" + o1.getClass().getCanonicalName());
        }
        return o1;
    }

    private static List<Oaf> convertToListOaf(String id, String s, Map<String, String> code2name) {
        String type = StringUtils.substringAfter((String)id, (String)":");
        switch (type.toLowerCase()) {
            case "native_oaf": {
                return new OafToOafMapper(code2name).processMdRecord(s);
            }
            case "native_odf": {
                return new OdfToOafMapper(code2name).processMdRecord(s);
            }
            case "datasource": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Datasource.class));
            }
            case "organization": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Organization.class));
            }
            case "project": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Project.class));
            }
            case "relation": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Relation.class));
            }
            case "publication": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Publication.class));
            }
            case "dataset": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Dataset.class));
            }
            case "software": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, Software.class));
            }
            case "otherresearchproduct": {
                return Arrays.asList(GenerateEntitiesApplication.convertFromJson(s, OtherResearchProduct.class));
            }
        }
        throw new RuntimeException("type not managed: " + type.toLowerCase());
    }

    private static Map<String, String> loadClassNames(String dbUrl, String dbUser, String dbPassword) throws IOException {
        log.info("Loading vocabulary terms from db...");
        HashMap<String, String> map = new HashMap<String, String>();
        try (DbClient dbClient = new DbClient(dbUrl, dbUser, dbPassword);){
            dbClient.processResults("select code, name from class", rs -> {
                try {
                    map.put(rs.getString("code"), rs.getString("name"));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        }
        log.info("Found " + map.size() + " terms.");
        return map;
    }

    private static Oaf convertFromJson(String s, Class<? extends Oaf> clazz) {
        try {
            return (Oaf)OBJECT_MAPPER.readValue(s, clazz);
        }
        catch (Exception e) {
            log.error("Error parsing object of class: " + clazz);
            log.error(s);
            throw new RuntimeException(e);
        }
    }

    private static boolean exists(JavaSparkContext context, String pathToFile) {
        try {
            FileSystem hdfs = FileSystem.get((Configuration)context.hadoopConfiguration());
            Path path = new Path(pathToFile);
            return hdfs.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

