/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.parser;

import eu.dnetlib.dhp.parser.utility.VtdUtilityParser;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.scholexplorer.DLIRelation;
import eu.dnetlib.dhp.schema.scholexplorer.DLIUnknown;
import eu.dnetlib.dhp.schema.scholexplorer.ProvenaceInfo;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.scholexplorer.relation.RelInfo;
import eu.dnetlib.scholexplorer.relation.RelationMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractScholexplorerParser {
    protected static final Log log = LogFactory.getLog(AbstractScholexplorerParser.class);
    static final Pattern pattern = Pattern.compile("10\\.\\d{4,9}/[-._;()/:A-Z0-9]+$", 2);
    private final List<String> datasetSubTypes = Arrays.asList("dataset", "software", "film", "sound", "physicalobject", "audiovisual", "collection", "other", "study", "metadata");

    public abstract List<Oaf> parseObject(String var1, RelationMapper var2);

    protected Map<String, String> getAttributes(XMLStreamReader parser) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attributesMap.put(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
        }
        return attributesMap;
    }

    protected List<StructuredProperty> extractSubject(List<VtdUtilityParser.Node> subjects) {
        ArrayList<StructuredProperty> subjectResult = new ArrayList<StructuredProperty>();
        if (subjects != null && subjects.size() > 0) {
            subjects.forEach(subjectMap -> {
                StructuredProperty subject = new StructuredProperty();
                subject.setValue(subjectMap.getTextValue());
                Qualifier schema = new Qualifier();
                schema.setClassid("dnet:subject");
                schema.setClassname("dnet:subject");
                schema.setSchemeid((String)subjectMap.getAttributes().get("subjectScheme"));
                schema.setSchemename((String)subjectMap.getAttributes().get("subjectScheme"));
                subject.setQualifier(schema);
                subjectResult.add(subject);
            });
        }
        return subjectResult;
    }

    protected StructuredProperty extractIdentifier(List<VtdUtilityParser.Node> identifierType, String fieldName) {
        StructuredProperty pid = new StructuredProperty();
        if (identifierType != null && identifierType.size() > 0) {
            VtdUtilityParser.Node result = identifierType.get(0);
            pid.setValue(result.getTextValue());
            Qualifier pidType = new Qualifier();
            pidType.setClassname((String)result.getAttributes().get(fieldName));
            pidType.setClassid((String)result.getAttributes().get(fieldName));
            pidType.setSchemename("dnet:pid_types");
            pidType.setSchemeid("dnet:pid_types");
            pid.setQualifier(pidType);
            return pid;
        }
        return null;
    }

    protected void inferPid(StructuredProperty input) {
        Matcher matcher = pattern.matcher(input.getValue());
        if (matcher.find()) {
            input.setValue(matcher.group());
            if (input.getQualifier() == null) {
                input.setQualifier(new Qualifier());
                input.getQualifier().setSchemename("dnet:pid_types");
                input.getQualifier().setSchemeid("dnet:pid_types");
            }
            input.getQualifier().setClassid("doi");
            input.getQualifier().setClassname("doi");
        }
    }

    protected String generateId(String pid, String pidType, String entityType) {
        String type;
        switch (entityType) {
            case "publication": {
                type = "50|";
                break;
            }
            case "dataset": {
                type = "60|";
                break;
            }
            case "unknown": {
                type = "70|";
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected value " + entityType);
            }
        }
        if ("dnet".equalsIgnoreCase(pidType)) {
            return type + StringUtils.substringAfter((String)pid, (String)"::");
        }
        return type + DHPUtils.md5((String)String.format("%s::%s", pid.toLowerCase().trim(), pidType.toLowerCase().trim()));
    }

    protected DLIUnknown createUnknownObject(String pid, String pidType, KeyValue cf, DataInfo di, String dateOfCollection) {
        DLIUnknown uk = new DLIUnknown();
        uk.setId(this.generateId(pid, pidType, "unknown"));
        ProvenaceInfo pi = new ProvenaceInfo();
        pi.setId(cf.getKey());
        pi.setName(cf.getValue());
        pi.setCompletionStatus("incomplete");
        uk.setDataInfo(di);
        uk.setDlicollectedfrom(Collections.singletonList(pi));
        StructuredProperty sourcePid = new StructuredProperty();
        sourcePid.setValue(pid);
        Qualifier pt = new Qualifier();
        pt.setClassname(pidType);
        pt.setClassid(pidType);
        pt.setSchemename("dnet:pid_types");
        pt.setSchemeid("dnet:pid_types");
        sourcePid.setQualifier(pt);
        uk.setPid(Collections.singletonList(sourcePid));
        uk.setDateofcollection(dateOfCollection);
        return uk;
    }

    protected void generateRelations(RelationMapper relationMapper, Result parsedObject, List<Oaf> result, DataInfo di, String dateOfCollection, List<VtdUtilityParser.Node> relatedIdentifiers) {
        if (relatedIdentifiers != null) {
            result.addAll(relatedIdentifiers.stream().flatMap(n -> {
                String inverseRelation;
                ArrayList<DLIRelation> rels = new ArrayList<DLIRelation>();
                DLIRelation r = new DLIRelation();
                r.setSource(parsedObject.getId());
                String relatedPid = n.getTextValue();
                String relatedPidType = (String)n.getAttributes().get("relatedIdentifierType");
                String relatedType = n.getAttributes().getOrDefault("entityType", "unknown");
                String relationSemantic = (String)n.getAttributes().get("relationType");
                String targetId = this.generateId(relatedPid, relatedPidType, relatedType);
                r.setDateOfCollection(dateOfCollection);
                if (relationMapper.containsKey((Object)relationSemantic.toLowerCase())) {
                    RelInfo relInfo = (RelInfo)relationMapper.get((Object)relationSemantic.toLowerCase());
                    relationSemantic = relInfo.getOriginal();
                    inverseRelation = relInfo.getInverse();
                } else {
                    relationSemantic = "Unknown";
                    inverseRelation = "Unknown";
                }
                r.setTarget(targetId);
                r.setRelType(relationSemantic);
                r.setRelClass("datacite");
                r.setCollectedfrom(parsedObject.getCollectedfrom());
                r.setDataInfo(di);
                rels.add(r);
                r = new DLIRelation();
                r.setDataInfo(di);
                r.setSource(targetId);
                r.setTarget(parsedObject.getId());
                r.setRelType(inverseRelation);
                r.setRelClass("datacite");
                r.setCollectedfrom(parsedObject.getCollectedfrom());
                r.setDateOfCollection(dateOfCollection);
                rels.add(r);
                if ("unknown".equalsIgnoreCase(relatedType)) {
                    result.add((Oaf)this.createUnknownObject(relatedPid, relatedPidType, (KeyValue)parsedObject.getCollectedfrom().get(0), di, dateOfCollection));
                }
                return rels.stream();
            }).collect(Collectors.toList()));
        }
    }
}

