/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.DbClient;
import eu.dnetlib.dhp.oa.graph.raw.common.AbstractMigrationApplication;
import eu.dnetlib.dhp.oa.graph.raw.common.OafMapperUtils;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MigrateDbEntitiesApplication
extends AbstractMigrationApplication
implements Closeable {
    private static final Log log = LogFactory.getLog(MigrateDbEntitiesApplication.class);
    public static final String SOURCE_TYPE = "source_type";
    public static final String TARGET_TYPE = "target_type";
    private final DbClient dbClient;
    private final long lastUpdateTimestamp;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateDbEntitiesApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/migrate_db_entities_parameters.json")));
        parser.parseArgument(args);
        String dbUrl = parser.get("postgresUrl");
        String dbUser = parser.get("postgresUser");
        String dbPassword = parser.get("postgresPassword");
        String hdfsPath = parser.get("hdfsPath");
        boolean processClaims = parser.get("action") != null && parser.get("action").equalsIgnoreCase("claims");
        try (MigrateDbEntitiesApplication smdbe = new MigrateDbEntitiesApplication(hdfsPath, dbUrl, dbUser, dbPassword);){
            if (processClaims) {
                log.info((Object)"Processing claims...");
                smdbe.execute("queryClaims.sql", smdbe::processClaims);
            } else {
                log.info((Object)"Processing datasources...");
                smdbe.execute("queryDatasources.sql", smdbe::processDatasource);
                log.info((Object)"Processing projects...");
                smdbe.execute("queryProjects.sql", smdbe::processProject);
                log.info((Object)"Processing orgs...");
                smdbe.execute("queryOrganizations.sql", smdbe::processOrganization);
                log.info((Object)"Processing relationsNoRemoval ds <-> orgs ...");
                smdbe.execute("queryDatasourceOrganization.sql", smdbe::processDatasourceOrganization);
                log.info((Object)"Processing projects <-> orgs ...");
                smdbe.execute("queryProjectOrganization.sql", smdbe::processProjectOrganization);
            }
            log.info((Object)"All done.");
        }
    }

    protected MigrateDbEntitiesApplication() {
        this.dbClient = null;
        this.lastUpdateTimestamp = new Date().getTime();
    }

    public MigrateDbEntitiesApplication(String hdfsPath, String dbUrl, String dbUser, String dbPassword) throws Exception {
        super(hdfsPath);
        this.dbClient = new DbClient(dbUrl, dbUser, dbPassword);
        this.lastUpdateTimestamp = new Date().getTime();
    }

    public void execute(String sqlFile, Function<ResultSet, List<Oaf>> producer) throws Exception {
        String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/sql/" + sqlFile));
        Consumer<ResultSet> consumer = rs -> ((List)producer.apply((ResultSet)rs)).forEach(oaf -> this.emitOaf((Oaf)oaf));
        this.dbClient.processResults(sql, consumer);
    }

    public List<Oaf> processDatasource(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Datasource ds = new Datasource();
            ds.setId(OafMapperUtils.createOpenaireId(10, rs.getString("datasourceid"), true));
            ds.setOriginalId(Arrays.asList(rs.getString("datasourceid")));
            ds.setCollectedfrom(OafMapperUtils.listKeyValues(OafMapperUtils.createOpenaireId(10, rs.getString("collectedfromid"), true), rs.getString("collectedfromname")));
            ds.setPid(new ArrayList());
            ds.setDateofcollection(OafMapperUtils.asString(rs.getDate("dateofcollection")));
            ds.setDateoftransformation(null);
            ds.setExtraInfo(new ArrayList());
            ds.setOaiprovenance(null);
            ds.setDatasourcetype(this.prepareQualifierSplitting(rs.getString("datasourcetype")));
            ds.setOpenairecompatibility(this.prepareQualifierSplitting(rs.getString("openairecompatibility")));
            ds.setOfficialname(OafMapperUtils.field(rs.getString("officialname"), info));
            ds.setEnglishname(OafMapperUtils.field(rs.getString("englishname"), info));
            ds.setWebsiteurl(OafMapperUtils.field(rs.getString("websiteurl"), info));
            ds.setLogourl(OafMapperUtils.field(rs.getString("logourl"), info));
            ds.setContactemail(OafMapperUtils.field(rs.getString("contactemail"), info));
            ds.setNamespaceprefix(OafMapperUtils.field(rs.getString("namespaceprefix"), info));
            ds.setLatitude(OafMapperUtils.field(Double.toString(rs.getDouble("latitude")), info));
            ds.setLongitude(OafMapperUtils.field(Double.toString(rs.getDouble("longitude")), info));
            ds.setDateofvalidation(OafMapperUtils.field(OafMapperUtils.asString(rs.getDate("dateofvalidation")), info));
            ds.setDescription(OafMapperUtils.field(rs.getString("description"), info));
            ds.setSubjects(this.prepareListOfStructProps(rs.getArray("subjects"), info));
            ds.setOdnumberofitems(OafMapperUtils.field(Double.toString(rs.getInt("odnumberofitems")), info));
            ds.setOdnumberofitemsdate(OafMapperUtils.field(OafMapperUtils.asString(rs.getDate("odnumberofitemsdate")), info));
            ds.setOdpolicies(OafMapperUtils.field(rs.getString("odpolicies"), info));
            ds.setOdlanguages(this.prepareListFields(rs.getArray("odlanguages"), info));
            ds.setOdcontenttypes(this.prepareListFields(rs.getArray("odcontenttypes"), info));
            ds.setAccessinfopackage(this.prepareListFields(rs.getArray("accessinfopackage"), info));
            ds.setReleasestartdate(OafMapperUtils.field(OafMapperUtils.asString(rs.getDate("releasestartdate")), info));
            ds.setReleaseenddate(OafMapperUtils.field(OafMapperUtils.asString(rs.getDate("releaseenddate")), info));
            ds.setMissionstatementurl(OafMapperUtils.field(rs.getString("missionstatementurl"), info));
            ds.setDataprovider(OafMapperUtils.field(rs.getBoolean("dataprovider"), info));
            ds.setServiceprovider(OafMapperUtils.field(rs.getBoolean("serviceprovider"), info));
            ds.setDatabaseaccesstype(OafMapperUtils.field(rs.getString("databaseaccesstype"), info));
            ds.setDatauploadtype(OafMapperUtils.field(rs.getString("datauploadtype"), info));
            ds.setDatabaseaccessrestriction(OafMapperUtils.field(rs.getString("databaseaccessrestriction"), info));
            ds.setDatauploadrestriction(OafMapperUtils.field(rs.getString("datauploadrestriction"), info));
            ds.setVersioning(OafMapperUtils.field(rs.getBoolean("versioning"), info));
            ds.setCitationguidelineurl(OafMapperUtils.field(rs.getString("citationguidelineurl"), info));
            ds.setQualitymanagementkind(OafMapperUtils.field(rs.getString("qualitymanagementkind"), info));
            ds.setPidsystems(OafMapperUtils.field(rs.getString("pidsystems"), info));
            ds.setCertificates(OafMapperUtils.field(rs.getString("certificates"), info));
            ds.setPolicies(new ArrayList());
            ds.setJournal(this.prepareJournal(rs.getString("officialname"), rs.getString("journal"), info));
            ds.setDataInfo(info);
            ds.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(ds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processProject(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Project p = new Project();
            p.setId(OafMapperUtils.createOpenaireId(40, rs.getString("projectid"), true));
            p.setOriginalId(Arrays.asList(rs.getString("projectid")));
            p.setCollectedfrom(OafMapperUtils.listKeyValues(OafMapperUtils.createOpenaireId(10, rs.getString("collectedfromid"), true), rs.getString("collectedfromname")));
            p.setPid(new ArrayList());
            p.setDateofcollection(OafMapperUtils.asString(rs.getDate("dateofcollection")));
            p.setDateoftransformation(OafMapperUtils.asString(rs.getDate("dateoftransformation")));
            p.setExtraInfo(new ArrayList());
            p.setOaiprovenance(null);
            p.setWebsiteurl(OafMapperUtils.field(rs.getString("websiteurl"), info));
            p.setCode(OafMapperUtils.field(rs.getString("code"), info));
            p.setAcronym(OafMapperUtils.field(rs.getString("acronym"), info));
            p.setTitle(OafMapperUtils.field(rs.getString("title"), info));
            p.setStartdate(OafMapperUtils.field(OafMapperUtils.asString(rs.getDate("startdate")), info));
            p.setEnddate(OafMapperUtils.field(OafMapperUtils.asString(rs.getDate("enddate")), info));
            p.setCallidentifier(OafMapperUtils.field(rs.getString("callidentifier"), info));
            p.setKeywords(OafMapperUtils.field(rs.getString("keywords"), info));
            p.setDuration(OafMapperUtils.field(Integer.toString(rs.getInt("duration")), info));
            p.setEcsc39(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecsc39")), info));
            p.setOamandatepublications(OafMapperUtils.field(Boolean.toString(rs.getBoolean("oamandatepublications")), info));
            p.setEcarticle29_3(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecarticle29_3")), info));
            p.setSubjects(this.prepareListOfStructProps(rs.getArray("subjects"), info));
            p.setFundingtree(this.prepareListFields(rs.getArray("fundingtree"), info));
            p.setContracttype(this.prepareQualifierSplitting(rs.getString("contracttype")));
            p.setOptional1(OafMapperUtils.field(rs.getString("optional1"), info));
            p.setOptional2(OafMapperUtils.field(rs.getString("optional2"), info));
            p.setJsonextrainfo(OafMapperUtils.field(rs.getString("jsonextrainfo"), info));
            p.setContactfullname(OafMapperUtils.field(rs.getString("contactfullname"), info));
            p.setContactfax(OafMapperUtils.field(rs.getString("contactfax"), info));
            p.setContactphone(OafMapperUtils.field(rs.getString("contactphone"), info));
            p.setContactemail(OafMapperUtils.field(rs.getString("contactemail"), info));
            p.setSummary(OafMapperUtils.field(rs.getString("summary"), info));
            p.setCurrency(OafMapperUtils.field(rs.getString("currency"), info));
            p.setTotalcost(new Float(rs.getDouble("totalcost")));
            p.setFundedamount(new Float(rs.getDouble("fundedamount")));
            p.setDataInfo(info);
            p.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(p);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Organization o = new Organization();
            o.setId(OafMapperUtils.createOpenaireId(20, rs.getString("organizationid"), true));
            o.setOriginalId(Arrays.asList(rs.getString("organizationid")));
            o.setCollectedfrom(OafMapperUtils.listKeyValues(OafMapperUtils.createOpenaireId(10, rs.getString("collectedfromid"), true), rs.getString("collectedfromname")));
            o.setPid(new ArrayList());
            o.setDateofcollection(OafMapperUtils.asString(rs.getDate("dateofcollection")));
            o.setDateoftransformation(OafMapperUtils.asString(rs.getDate("dateoftransformation")));
            o.setExtraInfo(new ArrayList());
            o.setOaiprovenance(null);
            o.setLegalshortname(OafMapperUtils.field(rs.getString("legalshortname"), info));
            o.setLegalname(OafMapperUtils.field(rs.getString("legalname"), info));
            o.setAlternativeNames(new ArrayList());
            o.setWebsiteurl(OafMapperUtils.field(rs.getString("websiteurl"), info));
            o.setLogourl(OafMapperUtils.field(rs.getString("logourl"), info));
            o.setEclegalbody(OafMapperUtils.field(Boolean.toString(rs.getBoolean("eclegalbody")), info));
            o.setEclegalperson(OafMapperUtils.field(Boolean.toString(rs.getBoolean("eclegalperson")), info));
            o.setEcnonprofit(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecnonprofit")), info));
            o.setEcresearchorganization(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecresearchorganization")), info));
            o.setEchighereducation(OafMapperUtils.field(Boolean.toString(rs.getBoolean("echighereducation")), info));
            o.setEcinternationalorganizationeurinterests(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecinternationalorganizationeurinterests")), info));
            o.setEcinternationalorganization(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecinternationalorganization")), info));
            o.setEcenterprise(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecenterprise")), info));
            o.setEcsmevalidated(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecsmevalidated")), info));
            o.setEcnutscode(OafMapperUtils.field(Boolean.toString(rs.getBoolean("ecnutscode")), info));
            o.setCountry(this.prepareQualifierSplitting(rs.getString("country")));
            o.setDataInfo(info);
            o.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processDatasourceOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId = OafMapperUtils.createOpenaireId(20, rs.getString("organization"), true);
            String dsId = OafMapperUtils.createOpenaireId(10, rs.getString("datasource"), true);
            List<KeyValue> collectedFrom = OafMapperUtils.listKeyValues(OafMapperUtils.createOpenaireId(10, rs.getString("collectedfromid"), true), rs.getString("collectedfromname"));
            Relation r1 = new Relation();
            r1.setRelType("datasourceOrganization");
            r1.setSubRelType("provision");
            r1.setRelClass("isProvidedBy");
            r1.setSource(dsId);
            r1.setTarget(orgId);
            r1.setCollectedfrom(collectedFrom);
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            Relation r2 = new Relation();
            r2.setRelType("datasourceOrganization");
            r2.setSubRelType("provision");
            r2.setRelClass("provides");
            r2.setSource(orgId);
            r2.setTarget(dsId);
            r2.setCollectedfrom(collectedFrom);
            r2.setDataInfo(info);
            r2.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processProjectOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId = OafMapperUtils.createOpenaireId(20, rs.getString("resporganization"), true);
            String projectId = OafMapperUtils.createOpenaireId(40, rs.getString("project"), true);
            List<KeyValue> collectedFrom = OafMapperUtils.listKeyValues(OafMapperUtils.createOpenaireId(10, rs.getString("collectedfromid"), true), rs.getString("collectedfromname"));
            Relation r1 = new Relation();
            r1.setRelType("projectOrganization");
            r1.setSubRelType("participation");
            r1.setRelClass("hasParticipant");
            r1.setSource(projectId);
            r1.setTarget(orgId);
            r1.setCollectedfrom(collectedFrom);
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            Relation r2 = new Relation();
            r2.setRelType("projectOrganization");
            r2.setSubRelType("participation");
            r2.setRelClass("isParticipant");
            r2.setSource(orgId);
            r2.setTarget(projectId);
            r2.setCollectedfrom(collectedFrom);
            r2.setDataInfo(info);
            r2.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processClaims(ResultSet rs) {
        DataInfo info = OafMapperUtils.dataInfo(false, null, false, false, OafMapperUtils.qualifier("user:claim", "user:claim", "dnet:provenanceActions", "dnet:provenanceActions"), "0.9");
        List<KeyValue> collectedFrom = OafMapperUtils.listKeyValues(OafMapperUtils.createOpenaireId(10, "infrastruct_::openaire", true), "OpenAIRE");
        try {
            if (rs.getString(SOURCE_TYPE).equals("context")) {
                Dataset r;
                if (rs.getString(TARGET_TYPE).equals("dataset")) {
                    r = new Dataset();
                    r.setResulttype(ModelConstants.DATASET_DEFAULT_RESULTTYPE);
                } else if (rs.getString(TARGET_TYPE).equals("software")) {
                    r = new Software();
                    r.setResulttype(ModelConstants.SOFTWARE_DEFAULT_RESULTTYPE);
                } else if (rs.getString(TARGET_TYPE).equals("other")) {
                    r = new OtherResearchProduct();
                    r.setResulttype(ModelConstants.ORP_DEFAULT_RESULTTYPE);
                } else {
                    r = new Publication();
                    r.setResulttype(ModelConstants.PUBLICATION_DEFAULT_RESULTTYPE);
                }
                r.setId(OafMapperUtils.createOpenaireId(50, rs.getString("target_id"), false));
                r.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
                r.setContext(this.prepareContext(rs.getString("source_id"), info));
                r.setDataInfo(info);
                r.setCollectedfrom(collectedFrom);
                return Arrays.asList(r);
            }
            String sourceId = OafMapperUtils.createOpenaireId(rs.getString(SOURCE_TYPE), rs.getString("source_id"), false);
            String targetId = OafMapperUtils.createOpenaireId(rs.getString(TARGET_TYPE), rs.getString("target_id"), false);
            Relation r1 = new Relation();
            Relation r2 = new Relation();
            if (rs.getString(SOURCE_TYPE).equals("project")) {
                r1.setCollectedfrom(collectedFrom);
                r1.setRelType("resultProject");
                r1.setSubRelType("outcome");
                r1.setRelClass("produces");
                r2.setCollectedfrom(collectedFrom);
                r2.setRelType("resultProject");
                r2.setSubRelType("outcome");
                r2.setRelClass("isProducedBy");
            } else {
                r1.setCollectedfrom(collectedFrom);
                r1.setRelType("resultResult");
                r1.setSubRelType("relationship");
                r1.setRelClass("isRelatedTo");
                r2.setCollectedfrom(collectedFrom);
                r2.setRelType("resultResult");
                r2.setSubRelType("relationship");
                r2.setRelClass("isRelatedTo");
            }
            r1.setSource(sourceId);
            r1.setTarget(targetId);
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            r2.setSource(targetId);
            r2.setTarget(sourceId);
            r2.setDataInfo(info);
            r2.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Context> prepareContext(String id, DataInfo dataInfo) {
        Context context = new Context();
        context.setId(id);
        context.setDataInfo(Arrays.asList(dataInfo));
        return Arrays.asList(context);
    }

    private DataInfo prepareDataInfo(ResultSet rs) throws SQLException {
        Boolean deletedbyinference = rs.getBoolean("deletedbyinference");
        String inferenceprovenance = rs.getString("inferenceprovenance");
        Boolean inferred = rs.getBoolean("inferred");
        String trust = rs.getString("trust");
        return OafMapperUtils.dataInfo(deletedbyinference, inferenceprovenance, inferred, false, ModelConstants.ENTITYREGISTRY_PROVENANCE_ACTION, trust);
    }

    private Qualifier prepareQualifierSplitting(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] arr = s.split("@@@");
        return arr.length == 4 ? OafMapperUtils.qualifier(arr[0], arr[1], arr[2], arr[3]) : null;
    }

    private List<Field<String>> prepareListFields(Array array, DataInfo info) {
        try {
            return array != null ? OafMapperUtils.listFields(info, (String[])array.getArray()) : new ArrayList<Field<String>>();
        }
        catch (SQLException e) {
            throw new RuntimeException("Invalid SQL array", e);
        }
    }

    private StructuredProperty prepareStructProp(String s, DataInfo dataInfo) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] parts = s.split("###");
        if (parts.length == 2) {
            String value = parts[0];
            String[] arr = parts[1].split("@@@");
            if (arr.length == 4) {
                return OafMapperUtils.structuredProperty(value, arr[0], arr[1], arr[2], arr[3], dataInfo);
            }
        }
        return null;
    }

    private List<StructuredProperty> prepareListOfStructProps(Array array, DataInfo dataInfo) throws SQLException {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        if (array != null) {
            for (String s : (String[])array.getArray()) {
                StructuredProperty sp = this.prepareStructProp(s, dataInfo);
                if (sp == null) continue;
                res.add(sp);
            }
        }
        return res;
    }

    private Journal prepareJournal(String name, String sj, DataInfo info) {
        String[] arr;
        if (StringUtils.isNotBlank((CharSequence)sj) && (arr = sj.split("@@@")).length == 3) {
            String lissn;
            String issn = StringUtils.isNotBlank((CharSequence)arr[0]) ? arr[0].trim() : null;
            String eissn = StringUtils.isNotBlank((CharSequence)arr[1]) ? arr[1].trim() : null;
            String string = lissn = StringUtils.isNotBlank((CharSequence)arr[2]) ? arr[2].trim() : null;
            if (issn != null || eissn != null || lissn != null) {
                return OafMapperUtils.journal(name, issn, eissn, eissn, null, null, null, null, null, null, null, info);
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.dbClient.close();
    }
}

