/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import com.google.common.collect.Iterables;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;

public class MdstoreClient
implements Closeable {
    private final MongoClient client;
    private final MongoDatabase db;
    private static final String COLL_METADATA = "metadata";
    private static final String COLL_METADATA_MANAGER = "metadataManager";
    private static final Log log = LogFactory.getLog(MdstoreClient.class);

    public MdstoreClient(String baseUrl, String dbName) {
        this.client = new MongoClient(new MongoClientURI(baseUrl));
        this.db = this.getDb(this.client, dbName);
    }

    public Map<String, String> validCollections(String mdFormat, String mdLayout, String mdInterpretation) {
        HashMap<String, String> transactions = new HashMap<String, String>();
        for (Document entry : this.getColl(this.db, COLL_METADATA_MANAGER, true).find()) {
            String currentId;
            String mdId = entry.getString((Object)"mdId");
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mdId, currentId = entry.getString((Object)"currentId")})) continue;
            transactions.put(mdId, currentId);
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (Document entry : this.getColl(this.db, COLL_METADATA, true).find()) {
            if (!entry.getString((Object)"format").equals(mdFormat) || !entry.getString((Object)"layout").equals(mdLayout) || !entry.getString((Object)"interpretation").equals(mdInterpretation) || !transactions.containsKey(entry.getString((Object)"mdId"))) continue;
            res.put(entry.getString((Object)"mdId"), (String)transactions.get(entry.getString((Object)"mdId")));
        }
        return res;
    }

    private MongoDatabase getDb(MongoClient client, String dbName) {
        if (!Iterables.contains((Iterable)client.listDatabaseNames(), (Object)dbName)) {
            String err = String.format("Database '%s' not found in %s", dbName, client.getAddress());
            log.warn((Object)err);
            throw new RuntimeException(err);
        }
        return client.getDatabase(dbName);
    }

    private MongoCollection<Document> getColl(MongoDatabase db, String collName, boolean abortIfMissing) {
        if (!Iterables.contains((Iterable)db.listCollectionNames(), (Object)collName)) {
            String err = String.format(String.format("Missing collection '%s' in database '%s'", collName, db.getName()), new Object[0]);
            log.warn((Object)err);
            if (abortIfMissing) {
                throw new RuntimeException(err);
            }
            return null;
        }
        return db.getCollection(collName);
    }

    public Iterable<String> listRecords(String collName) {
        MongoCollection<Document> coll = this.getColl(this.db, collName, false);
        return coll == null ? new ArrayList() : () -> StreamSupport.stream(coll.find().spliterator(), false).filter(e -> e.containsKey((Object)"body")).map(e -> e.getString((Object)"body")).iterator();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

