/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import eu.dnetlib.dhp.oa.graph.raw.GenerateEntitiesApplication;
import eu.dnetlib.dhp.oa.graph.raw.common.OafMapperUtils;
import eu.dnetlib.dhp.oa.graph.raw.common.Vocabulary;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyTerm;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class VocabularyGroup
implements Serializable {
    private final Map<String, Vocabulary> vocs = new HashMap<String, Vocabulary>();

    public static VocabularyGroup loadVocsFromIS(String isLookupUrl) throws IOException, ISLookUpException {
        ISLookUpService isLookUpService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        String xquery = IOUtils.toString((InputStream)GenerateEntitiesApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/xquery/load_vocabularies.xquery"));
        VocabularyGroup vocs = new VocabularyGroup();
        for (String s : isLookUpService.quickSearchProfile(xquery)) {
            String[] arr = s.split("@=@");
            if (arr.length != 4) continue;
            String vocId = arr[0].trim();
            String vocName = arr[1].trim();
            String termId = arr[2].trim();
            String termName = arr[3].trim();
            if (!vocs.vocabularyExists(vocId)) {
                vocs.addVocabulary(vocId, vocName);
            }
            vocs.addTerm(vocId, termId, termName);
        }
        return vocs;
    }

    public void addVocabulary(String id, String name) {
        this.vocs.put(id.toLowerCase(), new Vocabulary(id, name));
    }

    public void addTerm(String vocId, String id, String name) {
        if (this.vocabularyExists(vocId)) {
            this.vocs.get(vocId.toLowerCase()).addTerm(id, name);
        }
    }

    public VocabularyTerm getTerm(String vocId, String id) {
        if (this.termExists(vocId, id)) {
            return this.vocs.get(vocId.toLowerCase()).getTerm(id);
        }
        return new VocabularyTerm(id, id);
    }

    public Qualifier getTermAsQualifier(String vocId, String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return OafMapperUtils.qualifier("UNKNOWN", "UNKNOWN", vocId, vocId);
        }
        if (this.termExists(vocId, id)) {
            Vocabulary v = this.vocs.get(vocId.toLowerCase());
            VocabularyTerm t = v.getTerm(id);
            return OafMapperUtils.qualifier(t.getId(), t.getName(), v.getId(), v.getName());
        }
        return OafMapperUtils.qualifier(id, id, vocId, vocId);
    }

    public boolean termExists(String vocId, String id) {
        return this.vocabularyExists(vocId) && this.vocs.get(vocId.toLowerCase()).termExists(id);
    }

    public boolean vocabularyExists(String vocId) {
        return this.vocs.containsKey(vocId.toLowerCase());
    }
}

