/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.graph.raw.common.AbstractMigrationApplication;
import eu.dnetlib.dhp.oa.graph.raw.common.MdstoreClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MigrateMongoMdstoresApplication
extends AbstractMigrationApplication
implements Closeable {
    private static final Log log = LogFactory.getLog(MigrateMongoMdstoresApplication.class);
    private final MdstoreClient mdstoreClient;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/migrate_mongo_mstores_parameters.json")));
        parser.parseArgument(args);
        String mongoBaseUrl = parser.get("mongoBaseUrl");
        String mongoDb = parser.get("mongoDb");
        String mdFormat = parser.get("mdFormat");
        String mdLayout = parser.get("mdLayout");
        String mdInterpretation = parser.get("mdInterpretation");
        String hdfsPath = parser.get("hdfsPath");
        try (MigrateMongoMdstoresApplication app = new MigrateMongoMdstoresApplication(hdfsPath, mongoBaseUrl, mongoDb);){
            app.execute(mdFormat, mdLayout, mdInterpretation);
        }
    }

    public MigrateMongoMdstoresApplication(String hdfsPath, String mongoBaseUrl, String mongoDb) throws Exception {
        super(hdfsPath);
        this.mdstoreClient = new MdstoreClient(mongoBaseUrl, mongoDb);
    }

    public void execute(String format, String layout, String interpretation) {
        Map<String, String> colls = this.mdstoreClient.validCollections(format, layout, interpretation);
        log.info((Object)("Found " + colls.size() + " mdstores"));
        for (Map.Entry<String, String> entry : colls.entrySet()) {
            log.info((Object)("Processing mdstore " + entry.getKey() + " (collection: " + entry.getValue() + ")"));
            String currentColl = entry.getValue();
            for (String xml : this.mdstoreClient.listRecords(currentColl)) {
                this.emit(xml, String.format("%s-%s-%s", format, layout, interpretation));
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mdstoreClient.close();
    }
}

