/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.common.PacePerson;
import eu.dnetlib.dhp.oa.graph.raw.AbstractMdRecordToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.common.OafMapperUtils;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class OafToOafMapper
extends AbstractMdRecordToOafMapper {
    public OafToOafMapper(VocabularyGroup vocs, boolean invisible) {
        super(vocs, invisible);
    }

    @Override
    protected List<Author> prepareAuthors(Document doc, DataInfo info) {
        ArrayList<Author> res = new ArrayList<Author>();
        int pos = 1;
        for (Object o : doc.selectNodes("//dc:creator")) {
            Element e = (Element)o;
            Author author = new Author();
            author.setFullname(e.getText());
            author.setRank(Integer.valueOf(pos++));
            PacePerson p = new PacePerson(e.getText(), false);
            if (p.isAccurate()) {
                author.setName(p.getNormalisedFirstName());
                author.setSurname(p.getNormalisedSurname());
            }
            String pid = e.valueOf("./@nameIdentifier");
            String type = e.valueOf("./@nameIdentifierScheme").trim().toUpperCase().replaceAll(" ", "").replaceAll("_", "");
            author.setPid(new ArrayList());
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                if (type.startsWith("ORCID")) {
                    String cleanedId = pid.replaceAll("http://orcid.org/", "").replaceAll("https://orcid.org/", "");
                    author.getPid().add(OafMapperUtils.structuredProperty(cleanedId, ORCID_PID_TYPE, info));
                } else if (type.startsWith("MAGID")) {
                    author.getPid().add(OafMapperUtils.structuredProperty(pid, MAG_PID_TYPE, info));
                }
            }
            res.add(author);
        }
        return res;
    }

    @Override
    protected Qualifier prepareLanguages(Document doc) {
        return this.prepareQualifier((Node)doc, "//dc:language", "dnet:languages");
    }

    @Override
    protected List<StructuredProperty> prepareSubjects(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:subject", info);
    }

    @Override
    protected List<StructuredProperty> prepareTitles(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:title", MAIN_TITLE_QUALIFIER, info);
    }

    @Override
    protected List<Field<String>> prepareDescriptions(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:description", info);
    }

    @Override
    protected Field<String> preparePublisher(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:publisher", info);
    }

    @Override
    protected List<Field<String>> prepareFormats(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:format", info);
    }

    @Override
    protected List<Field<String>> prepareContributors(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:contributor", info);
    }

    @Override
    protected List<Field<String>> prepareCoverages(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:coverage", info);
    }

    @Override
    protected List<Instance> prepareInstances(Document doc, DataInfo info, KeyValue collectedfrom, KeyValue hostedby) {
        Instance instance = new Instance();
        instance.setInstancetype(this.prepareQualifier((Node)doc, "//dr:CobjCategory", "dnet:publication_resource"));
        instance.setCollectedfrom(collectedfrom);
        instance.setHostedby(hostedby);
        instance.setDateofacceptance(OafMapperUtils.field(doc.valueOf("//oaf:dateAccepted"), info));
        instance.setDistributionlocation(doc.valueOf("//oaf:distributionlocation"));
        instance.setAccessright(this.prepareQualifier((Node)doc, "//oaf:accessrights", "dnet:access_modes"));
        instance.setLicense(OafMapperUtils.field(doc.valueOf("//oaf:license"), info));
        instance.setRefereed(OafMapperUtils.field(doc.valueOf("//oaf:refereed"), info));
        instance.setProcessingchargeamount(OafMapperUtils.field(doc.valueOf("//oaf:processingchargeamount"), info));
        instance.setProcessingchargecurrency(OafMapperUtils.field(doc.valueOf("//oaf:processingchargeamount/@currency"), info));
        ArrayList nodes = Lists.newArrayList((Iterable)doc.selectNodes("//dc:identifier"));
        instance.setUrl((List)nodes.stream().filter(n -> StringUtils.isNotBlank((CharSequence)n.getText())).map(n -> n.getText().trim()).filter(u -> u.startsWith("http")).distinct().collect(Collectors.toCollection(ArrayList::new)));
        return Lists.newArrayList((Object[])new Instance[]{instance});
    }

    @Override
    protected List<Field<String>> prepareSources(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:source", info);
    }

    @Override
    protected List<StructuredProperty> prepareRelevantDates(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected Qualifier prepareSoftwareProgrammingLanguage(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareSoftwareCodeRepositoryUrl(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareSoftwareLicenses(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected List<Field<String>> prepareSoftwareDocumentationUrls(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<GeoLocation> prepareDatasetGeoLocations(Document doc, DataInfo info) {
        return new ArrayList<GeoLocation>();
    }

    @Override
    protected Field<String> prepareDatasetMetadataVersionNumber(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetLastMetadataUpdate(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetVersion(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetSize(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetDevice(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetStorageDate(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductTools(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactGroups(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactPersons(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Oaf> addOtherResultRels(Document doc, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        String docId = OafMapperUtils.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"), false);
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        for (Object o : doc.selectNodes("//*[local-name()='relatedDataset']")) {
            String originalId = ((Node)o).getText();
            if (!StringUtils.isNotBlank((CharSequence)originalId)) continue;
            String otherId = OafMapperUtils.createOpenaireId(50, originalId, false);
            res.add((Oaf)this.getRelation(docId, otherId, "resultResult", "publicationDataset", "isRelatedTo", collectedFrom, info, lastUpdateTimestamp));
            res.add((Oaf)this.getRelation(otherId, docId, "resultResult", "publicationDataset", "isRelatedTo", collectedFrom, info, lastUpdateTimestamp));
        }
        return res;
    }

    @Override
    protected Qualifier prepareResourceType(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareResultPids(Document doc, DataInfo info) {
        return this.prepareListStructPropsWithValidQualifier((Node)doc, "//oaf:identifier", "@identifierType", "dnet:pid_types", info);
    }
}

