/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.common.PacePerson;
import eu.dnetlib.dhp.oa.graph.raw.AbstractMdRecordToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.common.OafMapperUtils;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;

public class OdfToOafMapper
extends AbstractMdRecordToOafMapper {
    public static final String HTTP_DX_DOI_PREIFX = "http://dx.doi.org/";

    public OdfToOafMapper(VocabularyGroup vocs, boolean invisible) {
        super(vocs, invisible);
    }

    @Override
    protected List<StructuredProperty> prepareTitles(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//datacite:title", MAIN_TITLE_QUALIFIER, info);
    }

    @Override
    protected List<Author> prepareAuthors(Document doc, DataInfo info) {
        ArrayList<Author> res = new ArrayList<Author>();
        int pos = 1;
        for (Object o : doc.selectNodes("//datacite:creator")) {
            Node n = (Node)o;
            Author author = new Author();
            String fullname = n.valueOf("./datacite:creatorName");
            author.setFullname(fullname);
            PacePerson pp = new PacePerson(fullname, false);
            String name = n.valueOf("./datacite:givenName");
            if (StringUtils.isBlank((CharSequence)name) & pp.isAccurate()) {
                author.setName(pp.getNormalisedFirstName());
            } else {
                author.setName(name);
            }
            String surname = n.valueOf("./datacite:familyName");
            if (StringUtils.isBlank((CharSequence)surname) & pp.isAccurate()) {
                author.setSurname(pp.getNormalisedSurname());
            } else {
                author.setSurname(surname);
            }
            if (StringUtils.isBlank((CharSequence)author.getFullname())) {
                author.setFullname(String.format("%s, %s", author.getSurname(), author.getName()));
            }
            author.setAffiliation(this.prepareListFields(n, "./datacite:affiliation", info));
            author.setPid(this.preparePids(n, info));
            author.setRank(Integer.valueOf(pos++));
            res.add(author);
        }
        return res;
    }

    private List<StructuredProperty> preparePids(Node n, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : n.selectNodes("./datacite:nameIdentifier")) {
            String id = ((Node)o).getText();
            String type = ((Node)o).valueOf("./@nameIdentifierScheme").trim().toUpperCase().replaceAll(" ", "").replaceAll("_", "");
            if (type.startsWith("ORCID")) {
                String cleanedId = id.replaceAll("http://orcid.org/", "").replaceAll("https://orcid.org/", "");
                res.add(OafMapperUtils.structuredProperty(cleanedId, ORCID_PID_TYPE, info));
                continue;
            }
            if (!type.startsWith("MAGID")) continue;
            res.add(OafMapperUtils.structuredProperty(id, MAG_PID_TYPE, info));
        }
        return res;
    }

    @Override
    protected List<Instance> prepareInstances(Document doc, DataInfo info, KeyValue collectedfrom, KeyValue hostedby) {
        Instance instance = new Instance();
        instance.setInstancetype(this.prepareQualifier((Node)doc, "//dr:CobjCategory", "dnet:publication_resource"));
        instance.setCollectedfrom(collectedfrom);
        instance.setHostedby(hostedby);
        instance.setDateofacceptance(OafMapperUtils.field(doc.valueOf("//oaf:dateAccepted"), info));
        instance.setDistributionlocation(doc.valueOf("//oaf:distributionlocation"));
        instance.setAccessright(this.prepareQualifier((Node)doc, "//oaf:accessrights", "dnet:access_modes"));
        instance.setLicense(OafMapperUtils.field(doc.valueOf("//oaf:license"), info));
        instance.setRefereed(OafMapperUtils.field(doc.valueOf("//oaf:refereed"), info));
        instance.setProcessingchargeamount(OafMapperUtils.field(doc.valueOf("//oaf:processingchargeamount"), info));
        instance.setProcessingchargecurrency(OafMapperUtils.field(doc.valueOf("//oaf:processingchargeamount/@currency"), info));
        HashSet<String> url = new HashSet<String>();
        for (Object o : doc.selectNodes("//datacite:alternateIdentifier[@alternateIdentifierType='URL']")) {
            url.add(((Node)o).getText().trim());
        }
        for (Object o : doc.selectNodes("//datacite:identifier[@identifierType='URL']")) {
            url.add(((Node)o).getText().trim());
        }
        for (Object o : doc.selectNodes("//datacite:alternateIdentifier[@alternateIdentifierType='DOI']")) {
            url.add(HTTP_DX_DOI_PREIFX + ((Node)o).getText().trim());
        }
        for (Object o : doc.selectNodes("//datacite:identifier[@identifierType='DOI']")) {
            url.add(HTTP_DX_DOI_PREIFX + ((Node)o).getText().trim());
        }
        if (!url.isEmpty()) {
            instance.setUrl(new ArrayList());
            instance.getUrl().addAll(url);
        }
        return Arrays.asList(instance);
    }

    @Override
    protected List<Field<String>> prepareSources(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<StructuredProperty> prepareRelevantDates(Document doc, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : doc.selectNodes("//datacite:date")) {
            String dateType = ((Node)o).valueOf("@dateType");
            if (!StringUtils.isBlank((CharSequence)dateType) || dateType.equalsIgnoreCase("Accepted") || dateType.equalsIgnoreCase("Issued") || dateType.equalsIgnoreCase("Updated") || dateType.equalsIgnoreCase("Available")) continue;
            res.add(OafMapperUtils.structuredProperty(((Node)o).getText(), "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date", info));
        }
        return res;
    }

    @Override
    protected List<Field<String>> prepareCoverages(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareContributors(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:contributorName", info);
    }

    @Override
    protected List<Field<String>> prepareFormats(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:format", info);
    }

    @Override
    protected Field<String> preparePublisher(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//datacite:publisher", info);
    }

    @Override
    protected List<Field<String>> prepareDescriptions(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:description[@descriptionType='Abstract']", info);
    }

    @Override
    protected List<StructuredProperty> prepareSubjects(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//datacite:subject", info);
    }

    @Override
    protected Qualifier prepareLanguages(Document doc) {
        return this.prepareQualifier((Node)doc, "//datacite:language", "dnet:languages");
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductTools(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactGroups(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:contributor[@contributorType='ContactGroup']/datacite:contributorName", info);
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactPersons(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:contributor[@contributorType='ContactPerson']/datacite:contributorName", info);
    }

    @Override
    protected Qualifier prepareSoftwareProgrammingLanguage(Document doc, DataInfo info) {
        return this.prepareQualifier((Node)doc, "//datacite:format", "dnet:programming_languages");
    }

    @Override
    protected Field<String> prepareSoftwareCodeRepositoryUrl(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareSoftwareLicenses(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected List<Field<String>> prepareSoftwareDocumentationUrls(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//datacite:relatedIdentifier[@relatedIdentifierType='URL' and @relationType='IsDocumentedBy']", info);
    }

    @Override
    protected List<GeoLocation> prepareDatasetGeoLocations(Document doc, DataInfo info) {
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        for (Object o : doc.selectNodes("//datacite:geoLocation")) {
            GeoLocation loc = new GeoLocation();
            loc.setBox(((Node)o).valueOf("./datacite:geoLocationBox"));
            loc.setPlace(((Node)o).valueOf("./datacite:geoLocationPlace"));
            loc.setPoint(((Node)o).valueOf("./datacite:geoLocationPoint"));
            res.add(loc);
        }
        return res;
    }

    @Override
    protected Field<String> prepareDatasetMetadataVersionNumber(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetLastMetadataUpdate(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//datacite:date[@dateType='Updated']", info);
    }

    @Override
    protected Field<String> prepareDatasetVersion(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//datacite:version", info);
    }

    @Override
    protected Field<String> prepareDatasetSize(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//datacite:size", info);
    }

    @Override
    protected Field<String> prepareDatasetDevice(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetStorageDate(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//datacite:date[@dateType='Issued']", info);
    }

    @Override
    protected List<Oaf> addOtherResultRels(Document doc, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        String docId = OafMapperUtils.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"), false);
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        for (Object o : doc.selectNodes("//datacite:relatedIdentifier[@relatedIdentifierType='OPENAIRE']")) {
            String originalId = ((Node)o).getText();
            if (!StringUtils.isNotBlank((CharSequence)originalId)) continue;
            String otherId = OafMapperUtils.createOpenaireId(50, originalId, false);
            String type = ((Node)o).valueOf("@relationType");
            if (type.equalsIgnoreCase("IsSupplementTo")) {
                res.add((Oaf)this.getRelation(docId, otherId, "resultResult", "supplement", "isSupplementTo", collectedFrom, info, lastUpdateTimestamp));
                res.add((Oaf)this.getRelation(otherId, docId, "resultResult", "supplement", "isSupplementedBy", collectedFrom, info, lastUpdateTimestamp));
                continue;
            }
            if (!type.equals("IsPartOf")) continue;
            res.add((Oaf)this.getRelation(docId, otherId, "resultResult", "part", "IsPartOf", collectedFrom, info, lastUpdateTimestamp));
            res.add((Oaf)this.getRelation(otherId, docId, "resultResult", "part", "HasParts", collectedFrom, info, lastUpdateTimestamp));
        }
        return res;
    }

    @Override
    protected Qualifier prepareResourceType(Document doc, DataInfo info) {
        return this.prepareQualifier((Node)doc, "//*[local-name() = 'resource']//*[local-name() = 'resourceType']", "dnet:dataCite_resource");
    }

    @Override
    protected List<StructuredProperty> prepareResultPids(Document doc, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        res.addAll(this.prepareListStructPropsWithValidQualifier((Node)doc, "//oaf:identifier", "@identifierType", "dnet:pid_types", info));
        res.addAll(this.prepareListStructPropsWithValidQualifier((Node)doc, "//datacite:identifier[@identifierType != 'URL']", "@identifierType", "dnet:pid_types", info));
        res.addAll(this.prepareListStructPropsWithValidQualifier((Node)doc, "//datacite:alternateIdentifier[@alternateIdentifierType != 'URL']", "@alternateIdentifierType", "dnet:pid_types", info));
        return res;
    }
}

