/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.codehaus.jackson.map.ObjectMapper;

public class AbstractMigrationApplication
implements Closeable {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Text key = new Text();
    private final Text value = new Text();
    private final SequenceFile.Writer writer;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Log log = LogFactory.getLog(AbstractMigrationApplication.class);

    protected AbstractMigrationApplication() {
        this.writer = null;
    }

    public AbstractMigrationApplication(String hdfsPath) throws Exception {
        log.info((Object)String.format("Creating SequenceFile Writer, hdfsPath=%s", hdfsPath));
        this.writer = SequenceFile.createWriter((Configuration)this.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(hdfsPath)), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
    }

    private Configuration getConf() throws IOException {
        Configuration conf = new Configuration();
        return conf;
    }

    protected void emit(String s, String type) {
        try {
            this.key.set(this.counter.getAndIncrement() + ":" + type);
            this.value.set(s);
            this.writer.append((Writable)this.key, (Writable)this.value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void emitOaf(Oaf oaf) {
        try {
            this.emit(this.objectMapper.writeValueAsString((Object)oaf), oaf.getClass().getSimpleName().toLowerCase());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void close() throws IOException {
        this.writer.hflush();
        this.writer.close();
    }
}

