/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.oa.graph.raw.common.OafMapperUtils;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyGroup;
import eu.dnetlib.dhp.schema.common.LicenseComparator;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public abstract class AbstractMdRecordToOafMapper {
    protected final VocabularyGroup vocs;
    private final boolean invisible;
    protected static final String DATACITE_SCHEMA_KERNEL_4 = "http://datacite.org/schema/kernel-4";
    protected static final String DATACITE_SCHEMA_KERNEL_3 = "http://datacite.org/schema/kernel-3";
    protected static final Qualifier ORCID_PID_TYPE = OafMapperUtils.qualifier("ORCID", "Open Researcher and Contributor ID", "dnet:pid_types", "dnet:pid_types");
    protected static final Qualifier MAG_PID_TYPE = OafMapperUtils.qualifier("MAGIdentifier", "Microsoft Academic Graph Identifier", "dnet:pid_types", "dnet:pid_types");
    protected static final Map<String, String> nsContext = new HashMap<String, String>();
    protected static final Qualifier MAIN_TITLE_QUALIFIER;

    protected AbstractMdRecordToOafMapper(VocabularyGroup vocs, boolean invisible) {
        this.vocs = vocs;
        this.invisible = invisible;
    }

    public List<Oaf> processMdRecord(String xml) {
        try {
            KeyValue hostedBy;
            DocumentFactory.getInstance().setXPathNamespaceURIs(nsContext);
            Document doc = DocumentHelper.parseText((String)xml.replaceAll(DATACITE_SCHEMA_KERNEL_4, DATACITE_SCHEMA_KERNEL_3));
            String type = doc.valueOf("//dr:CobjCategory/@type");
            KeyValue collectedFrom = this.getProvenanceDatasource(doc, "//oaf:collectedFrom/@id", "//oaf:collectedFrom/@name");
            if (collectedFrom == null) {
                return null;
            }
            KeyValue keyValue = hostedBy = StringUtils.isBlank((CharSequence)doc.valueOf("//oaf:hostedBy/@id")) ? collectedFrom : this.getProvenanceDatasource(doc, "//oaf:hostedBy/@id", "//oaf:hostedBy/@name");
            if (hostedBy == null) {
                return null;
            }
            DataInfo info = this.prepareDataInfo(doc, this.invisible);
            long lastUpdateTimestamp = new Date().getTime();
            return this.createOafs(doc, type, collectedFrom, hostedBy, info, lastUpdateTimestamp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyValue getProvenanceDatasource(Document doc, String xpathId, String xpathName) {
        String dsId = doc.valueOf(xpathId);
        String dsName = doc.valueOf(xpathName);
        if (StringUtils.isBlank((CharSequence)dsId) | StringUtils.isBlank((CharSequence)dsName)) {
            return null;
        }
        return OafMapperUtils.keyValue(OafMapperUtils.createOpenaireId(10, dsId, true), dsName);
    }

    protected List<Oaf> createOafs(Document doc, String type, KeyValue collectedFrom, KeyValue hostedBy, DataInfo info, long lastUpdateTimestamp) {
        ArrayList<Oaf> oafs = new ArrayList<Oaf>();
        switch (type.toLowerCase()) {
            case "publication": {
                Publication p = new Publication();
                this.populateResultFields((Result)p, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                p.setResulttype(ModelConstants.PUBLICATION_DEFAULT_RESULTTYPE);
                p.setJournal(this.prepareJournal(doc, info));
                oafs.add((Oaf)p);
                break;
            }
            case "dataset": {
                Dataset d = new Dataset();
                this.populateResultFields((Result)d, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                d.setResulttype(ModelConstants.DATASET_DEFAULT_RESULTTYPE);
                d.setStoragedate(this.prepareDatasetStorageDate(doc, info));
                d.setDevice(this.prepareDatasetDevice(doc, info));
                d.setSize(this.prepareDatasetSize(doc, info));
                d.setVersion(this.prepareDatasetVersion(doc, info));
                d.setLastmetadataupdate(this.prepareDatasetLastMetadataUpdate(doc, info));
                d.setMetadataversionnumber(this.prepareDatasetMetadataVersionNumber(doc, info));
                d.setGeolocation(this.prepareDatasetGeoLocations(doc, info));
                oafs.add((Oaf)d);
                break;
            }
            case "software": {
                Software s = new Software();
                this.populateResultFields((Result)s, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                s.setResulttype(ModelConstants.SOFTWARE_DEFAULT_RESULTTYPE);
                s.setDocumentationUrl(this.prepareSoftwareDocumentationUrls(doc, info));
                s.setLicense(this.prepareSoftwareLicenses(doc, info));
                s.setCodeRepositoryUrl(this.prepareSoftwareCodeRepositoryUrl(doc, info));
                s.setProgrammingLanguage(this.prepareSoftwareProgrammingLanguage(doc, info));
                oafs.add((Oaf)s);
                break;
            }
            default: {
                OtherResearchProduct o = new OtherResearchProduct();
                this.populateResultFields((Result)o, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                o.setResulttype(ModelConstants.ORP_DEFAULT_RESULTTYPE);
                o.setContactperson(this.prepareOtherResearchProductContactPersons(doc, info));
                o.setContactgroup(this.prepareOtherResearchProductContactGroups(doc, info));
                o.setTool(this.prepareOtherResearchProductTools(doc, info));
                oafs.add((Oaf)o);
            }
        }
        if (!oafs.isEmpty()) {
            oafs.addAll(this.addProjectRels(doc, collectedFrom, info, lastUpdateTimestamp));
            oafs.addAll(this.addOtherResultRels(doc, collectedFrom, info, lastUpdateTimestamp));
        }
        return oafs;
    }

    private List<Oaf> addProjectRels(Document doc, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        String docId = OafMapperUtils.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"), false);
        for (Object o : doc.selectNodes("//oaf:projectid")) {
            String originalId = ((Node)o).getText();
            if (!StringUtils.isNotBlank((CharSequence)originalId)) continue;
            String projectId = OafMapperUtils.createOpenaireId(40, originalId, true);
            res.add((Oaf)this.getRelation(docId, projectId, "resultProject", "outcome", "isProducedBy", collectedFrom, info, lastUpdateTimestamp));
            res.add((Oaf)this.getRelation(projectId, docId, "resultProject", "outcome", "produces", collectedFrom, info, lastUpdateTimestamp));
        }
        return res;
    }

    protected Relation getRelation(String source, String target, String relType, String subRelType, String relClass, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        Relation rel = new Relation();
        rel.setRelType(relType);
        rel.setSubRelType(subRelType);
        rel.setRelClass(relClass);
        rel.setSource(source);
        rel.setTarget(target);
        rel.setCollectedfrom(Arrays.asList(collectedFrom));
        rel.setDataInfo(info);
        rel.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
        return rel;
    }

    protected abstract List<Oaf> addOtherResultRels(Document var1, KeyValue var2, DataInfo var3, long var4);

    private void populateResultFields(Result r, Document doc, KeyValue collectedFrom, KeyValue hostedBy, DataInfo info, long lastUpdateTimestamp) {
        r.setDataInfo(info);
        r.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
        r.setId(OafMapperUtils.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"), false));
        r.setOriginalId(Arrays.asList(doc.valueOf("//dri:objIdentifier")));
        r.setCollectedfrom(Arrays.asList(collectedFrom));
        r.setPid(this.prepareResultPids(doc, info));
        r.setDateofcollection(doc.valueOf("//dr:dateOfCollection"));
        r.setDateoftransformation(doc.valueOf("//dr:dateOfTransformation"));
        r.setExtraInfo(new ArrayList());
        r.setOaiprovenance(this.prepareOAIprovenance(doc));
        r.setAuthor(this.prepareAuthors(doc, info));
        r.setLanguage(this.prepareLanguages(doc));
        r.setCountry(new ArrayList());
        r.setSubject(this.prepareSubjects(doc, info));
        r.setTitle(this.prepareTitles(doc, info));
        r.setRelevantdate(this.prepareRelevantDates(doc, info));
        r.setDescription(this.prepareDescriptions(doc, info));
        r.setDateofacceptance(this.prepareField((Node)doc, "//oaf:dateAccepted", info));
        r.setPublisher(this.preparePublisher(doc, info));
        r.setEmbargoenddate(this.prepareField((Node)doc, "//oaf:embargoenddate", info));
        r.setSource(this.prepareSources(doc, info));
        r.setFulltext(new ArrayList());
        r.setFormat(this.prepareFormats(doc, info));
        r.setContributor(this.prepareContributors(doc, info));
        r.setResourcetype(this.prepareResourceType(doc, info));
        r.setCoverage(this.prepareCoverages(doc, info));
        r.setContext(this.prepareContexts(doc, info));
        r.setExternalReference(new ArrayList());
        List<Instance> instances = this.prepareInstances(doc, info, collectedFrom, hostedBy);
        r.setInstance(instances);
        r.setBestaccessright(AbstractMdRecordToOafMapper.getBestAccessRights(instances));
    }

    protected abstract List<StructuredProperty> prepareResultPids(Document var1, DataInfo var2);

    private List<Context> prepareContexts(Document doc, DataInfo info) {
        ArrayList<Context> list = new ArrayList<Context>();
        for (Object o : doc.selectNodes("//oaf:concept")) {
            String cid = ((Node)o).valueOf("@id");
            if (!StringUtils.isNotBlank((CharSequence)cid)) continue;
            Context c = new Context();
            c.setId(cid);
            c.setDataInfo(Arrays.asList(info));
            list.add(c);
        }
        return list;
    }

    protected abstract Qualifier prepareResourceType(Document var1, DataInfo var2);

    protected abstract List<Instance> prepareInstances(Document var1, DataInfo var2, KeyValue var3, KeyValue var4);

    protected abstract List<Field<String>> prepareSources(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareRelevantDates(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareCoverages(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareContributors(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareFormats(Document var1, DataInfo var2);

    protected abstract Field<String> preparePublisher(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareDescriptions(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareTitles(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareSubjects(Document var1, DataInfo var2);

    protected abstract Qualifier prepareLanguages(Document var1);

    protected abstract List<Author> prepareAuthors(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductTools(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductContactGroups(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductContactPersons(Document var1, DataInfo var2);

    protected abstract Qualifier prepareSoftwareProgrammingLanguage(Document var1, DataInfo var2);

    protected abstract Field<String> prepareSoftwareCodeRepositoryUrl(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareSoftwareLicenses(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareSoftwareDocumentationUrls(Document var1, DataInfo var2);

    protected abstract List<GeoLocation> prepareDatasetGeoLocations(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetMetadataVersionNumber(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetLastMetadataUpdate(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetVersion(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetSize(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetDevice(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetStorageDate(Document var1, DataInfo var2);

    protected static Qualifier getBestAccessRights(List<Instance> instanceList) {
        if (instanceList != null) {
            Qualifier rights;
            Optional<Qualifier> min = instanceList.stream().map(i -> i.getAccessright()).min((Comparator<Qualifier>)new LicenseComparator());
            Qualifier qualifier = rights = min.isPresent() ? min.get() : new Qualifier();
            if (StringUtils.isBlank((CharSequence)rights.getClassid())) {
                rights.setClassid("UNKNOWN");
            }
            if (StringUtils.isBlank((CharSequence)rights.getClassname()) || "UNKNOWN".equalsIgnoreCase(rights.getClassname())) {
                rights.setClassname("not available");
            }
            if (StringUtils.isBlank((CharSequence)rights.getSchemeid())) {
                rights.setSchemeid("dnet:access_modes");
            }
            if (StringUtils.isBlank((CharSequence)rights.getSchemename())) {
                rights.setSchemename("dnet:access_modes");
            }
            return rights;
        }
        return null;
    }

    private Journal prepareJournal(Document doc, DataInfo info) {
        Node n = doc.selectSingleNode("//oaf:journal");
        if (n != null) {
            String name = n.getText();
            String issnPrinted = n.valueOf("@issn");
            String issnOnline = n.valueOf("@eissn");
            String issnLinking = n.valueOf("@lissn");
            String ep = n.valueOf("@ep");
            String iss = n.valueOf("@iss");
            String sp = n.valueOf("@sp");
            String vol = n.valueOf("@vol");
            String edition = n.valueOf("@edition");
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return OafMapperUtils.journal(name, issnPrinted, issnOnline, issnLinking, ep, iss, sp, vol, edition, null, null, info);
            }
        }
        return null;
    }

    protected Qualifier prepareQualifier(Node node, String xpath, String schemeId) {
        return this.prepareQualifier(node.valueOf(xpath).trim(), schemeId);
    }

    protected Qualifier prepareQualifier(String classId, String schemeId) {
        return this.vocs.getTermAsQualifier(schemeId, classId);
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, String xpathClassId, String schemeId, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            String classId = n.valueOf(xpathClassId).trim();
            res.add(OafMapperUtils.structuredProperty(n.getText(), this.prepareQualifier(classId, schemeId), info));
        }
        return res;
    }

    protected List<StructuredProperty> prepareListStructPropsWithValidQualifier(Node node, String xpath, String xpathClassId, String schemeId, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            String classId = n.valueOf(xpathClassId).trim();
            if (!this.vocs.termExists(schemeId, classId)) continue;
            res.add(OafMapperUtils.structuredProperty(n.getText(), this.vocs.getTermAsQualifier(schemeId, classId), info));
        }
        return res;
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, Qualifier qualifier, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(OafMapperUtils.structuredProperty(n.getText(), qualifier, info));
        }
        return res;
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(OafMapperUtils.structuredProperty(n.getText(), n.valueOf("@classid"), n.valueOf("@classname"), n.valueOf("@schemeid"), n.valueOf("@schemename"), info));
        }
        return res;
    }

    protected OAIProvenance prepareOAIprovenance(Document doc) {
        Node n = doc.selectSingleNode("//*[local-name()='provenance']/*[local-name()='originDescription']");
        if (n == null) {
            return null;
        }
        String identifier = n.valueOf("./*[local-name()='identifier']");
        String baseURL = n.valueOf("./*[local-name()='baseURL']");
        String metadataNamespace = n.valueOf("./*[local-name()='metadataNamespace']");
        boolean altered = n.valueOf("@altered").equalsIgnoreCase("true");
        String datestamp = n.valueOf("./*[local-name()='datestamp']");
        String harvestDate = n.valueOf("@harvestDate");
        return OafMapperUtils.oaiIProvenance(identifier, baseURL, metadataNamespace, altered, datestamp, harvestDate);
    }

    protected DataInfo prepareDataInfo(Document doc, boolean invisible) {
        Node n = doc.selectSingleNode("//oaf:datainfo");
        if (n == null) {
            return OafMapperUtils.dataInfo(false, null, false, invisible, ModelConstants.REPOSITORY_PROVENANCE_ACTIONS, "0.9");
        }
        String paClassId = n.valueOf("./oaf:provenanceaction/@classid");
        String paClassName = n.valueOf("./oaf:provenanceaction/@classname");
        String paSchemeId = n.valueOf("./oaf:provenanceaction/@schemeid");
        String paSchemeName = n.valueOf("./oaf:provenanceaction/@schemename");
        boolean deletedbyinference = Boolean.parseBoolean(n.valueOf("./oaf:deletedbyinference"));
        String inferenceprovenance = n.valueOf("./oaf:inferenceprovenance");
        Boolean inferred = Boolean.parseBoolean(n.valueOf("./oaf:inferred"));
        String trust = n.valueOf("./oaf:trust");
        return OafMapperUtils.dataInfo(deletedbyinference, inferenceprovenance, inferred, invisible, OafMapperUtils.qualifier(paClassId, paClassName, paSchemeId, paSchemeName), trust);
    }

    protected Field<String> prepareField(Node node, String xpath, DataInfo info) {
        return OafMapperUtils.field(node.valueOf(xpath), info);
    }

    protected List<Field<String>> prepareListFields(Node node, String xpath, DataInfo info) {
        return OafMapperUtils.listFields(info, this.prepareListString(node, xpath));
    }

    protected List<String> prepareListString(Node node, String xpath) {
        ArrayList<String> res = new ArrayList<String>();
        for (Object o : node.selectNodes(xpath)) {
            String s = ((Node)o).getText().trim();
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            res.add(s);
        }
        return res;
    }

    static {
        nsContext.put("dr", "http://www.driver-repository.eu/namespace/dr");
        nsContext.put("dri", "http://www.driver-repository.eu/namespace/dri");
        nsContext.put("oaf", "http://namespace.openaire.eu/oaf");
        nsContext.put("oai", "http://www.openarchives.org/OAI/2.0/");
        nsContext.put("prov", "http://www.openarchives.org/OAI/2.0/provenance");
        nsContext.put("dc", "http://purl.org/dc/elements/1.1/");
        nsContext.put("datacite", DATACITE_SCHEMA_KERNEL_3);
        MAIN_TITLE_QUALIFIER = OafMapperUtils.qualifier("main title", "main title", "dnet:dataCite_title", "dnet:dataCite_title");
    }
}

