/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.graph.clean.CleaningRule;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanGraphProperties {
    private static final Logger log = LoggerFactory.getLogger(CleanGraphProperties.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)CleanGraphProperties.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/input_clean_graph_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        String graphTableClassName = parser.get("graphTableClassName");
        log.info("graphTableClassName: {}", (Object)graphTableClassName);
        Class<?> entityClazz = Class.forName(graphTableClassName);
        ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        VocabularyGroup vocs = VocabularyGroup.loadVocsFromIS(isLookupService);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            CleanGraphProperties.removeOutputDir(spark, outputPath);
            CleanGraphProperties.fixGraphTable(spark, vocs, inputPath, entityClazz, outputPath);
        });
    }

    private static <T extends Oaf> void fixGraphTable(SparkSession spark, VocabularyGroup vocs, String inputPath, Class<T> clazz, String outputPath) {
        CleaningRule rule = new CleaningRule(vocs);
        CleanGraphProperties.readTableFromPath(spark, inputPath, clazz).map(rule, Encoders.bean(clazz)).write().mode(SaveMode.Overwrite).parquet(outputPath);
    }

    private static <T extends Oaf> Dataset<T> readTableFromPath(SparkSession spark, String inputEntityPath, Class<T> clazz) {
        log.info("Reading Graph table from: {}", (Object)inputEntityPath);
        return spark.read().textFile(inputEntityPath).map((MapFunction & Serializable)value -> (Oaf)OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

