/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import com.google.common.collect.Maps;
import eu.dnetlib.dhp.oa.graph.clean.OafNavigator2;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;

public class CleaningRule<T extends Oaf>
implements MapFunction<T, T> {
    private VocabularyGroup vocabularies;
    private Map<Class, Function<Object, Object>> mapping = Maps.newHashMap();

    public CleaningRule(VocabularyGroup vocabularies) {
        this.vocabularies = vocabularies;
        this.mapping.put(Qualifier.class, o -> this.patchQualifier(o));
        this.mapping.put(StructuredProperty.class, o -> this.patchSp(o));
        this.mapping.put(Field.class, o -> this.patchStringField(o));
    }

    public T call(T value) throws Exception {
        OafNavigator2.apply(value, this.mapping);
        return value;
    }

    private Object patchQualifier(Object o) {
        Qualifier q = (Qualifier)o;
        if (this.vocabularies.vocabularyExists(q.getSchemeid())) {
            return this.vocabularies.lookup(q.getSchemeid(), q.getClassid());
        }
        return o;
    }

    private Object patchSp(Object o) {
        StructuredProperty sp = (StructuredProperty)o;
        if (StringUtils.isBlank((CharSequence)sp.getValue())) {
            return null;
        }
        return o;
    }

    private Object patchStringField(Object o) {
        Field f = (Field)o;
        try {
            if (StringUtils.isBlank((CharSequence)((String)f.getValue()))) {
                return null;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return o;
    }

    public VocabularyGroup getVocabularies() {
        return this.vocabularies;
    }
}

