/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class OafNavigator {
    public static <E extends Oaf> E apply(E oaf, Map<Class, Function<Object, Object>> mapping) {
        OafNavigator.reflect(oaf, mapping);
        return oaf;
    }

    public static void reflect(Object o, Map<Class, Function<Object, Object>> mapping) {
        OafNavigator.visit(o, mapping);
    }

    public static void visit(Object thingy, Map<Class, Function<Object, Object>> mapping) {
        block11: {
            try {
                Class<?> clazz = thingy.getClass();
                if (OafNavigator.isPrimitive(thingy) || !clazz.getPackage().equals(Oaf.class.getPackage())) break block11;
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                    try {
                        Object value = descriptor.getReadMethod().invoke(thingy, new Object[0]);
                        if (value == null || OafNavigator.isPrimitive(value)) continue;
                        System.out.println("VISITING " + descriptor.getName() + " " + descriptor.getPropertyType());
                        if (Iterable.class.isAssignableFrom(descriptor.getPropertyType())) {
                            for (Object vi : (Iterable)value) {
                                OafNavigator.visit(vi, mapping);
                            }
                            continue;
                        }
                        if (mapping.keySet().contains(value.getClass())) {
                            Object newValue = mapping.get(value.getClass()).apply(value);
                            System.out.println("PATCHING " + descriptor.getName() + " " + descriptor.getPropertyType());
                            System.out.println("OLD VALUE " + OafNavigator.getObjectMapper().writeValueAsString(value));
                            System.out.println("NEW VALUE " + OafNavigator.getObjectMapper().writeValueAsString(newValue));
                            descriptor.getWriteMethod().invoke(newValue, new Object[0]);
                        }
                        OafNavigator.visit(value, mapping);
                    }
                    catch (IllegalArgumentException value) {
                    }
                    catch (IllegalAccessException value) {
                    }
                    catch (InvocationTargetException value) {
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper;
    }

    private static void navigate(Object o, Map<Class, Function<Object, Object>> mapping) {
        if (Objects.isNull(o) || OafNavigator.isPrimitive(o)) {
            return;
        }
        try {
            for (Field field : OafNavigator.getAllFields(o.getClass())) {
                Object[] fs;
                System.out.println(field.getName());
                field.setAccessible(true);
                Object value = field.get(o);
                if (!Objects.nonNull(value)) continue;
                Class<?> fieldType = field.getType();
                if (fieldType.isArray() && !fieldType.getComponentType().isPrimitive()) {
                    fs = (Object[])value;
                    for (Object fi : fs) {
                        OafNavigator.navigate(fi, mapping);
                    }
                }
                if (Iterable.class.isAssignableFrom(fieldType)) {
                    fs = (Object[])value;
                    for (Object e : fs) {
                        OafNavigator.navigate(e, mapping);
                    }
                    continue;
                }
                if (!mapping.keySet().contains(value.getClass())) continue;
                System.out.println("PATCHING " + field.getName());
                field.set(o, mapping.get(value.getClass()).apply(value));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isPrimitive(Object o) {
        return o.getClass().isPrimitive() || o instanceof Class || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Long || o instanceof Boolean || o instanceof String || o instanceof Byte;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        return OafNavigator.getAllFields(new LinkedList<Field>(), clazz);
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (Objects.nonNull(superclass) && superclass.getPackage().equals(Oaf.class.getPackage())) {
            OafNavigator.getAllFields(fields, superclass);
        }
        return fields;
    }
}

