/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class OafNavigator2 {
    public static <E extends Oaf> E apply(E oaf, Map<Class, Function<Object, Object>> mapping) {
        OafNavigator2.navigate(oaf, mapping);
        return oaf;
    }

    private static void navigate(Object o, Map<Class, Function<Object, Object>> mapping) {
        if (Objects.isNull(o) || OafNavigator2.isPrimitive(o)) {
            return;
        }
        try {
            for (Field field : OafNavigator2.getAllFields(o.getClass())) {
                Object newValue;
                Object[] fs;
                field.setAccessible(true);
                Object value = field.get(o);
                if (!Objects.nonNull(value)) continue;
                Class<?> fieldType = field.getType();
                if (fieldType.isArray() && !fieldType.getComponentType().isPrimitive()) {
                    fs = (Object[])value;
                    for (Object fi : fs) {
                        OafNavigator2.navigate(fi, mapping);
                    }
                }
                if (Iterable.class.isAssignableFrom(fieldType)) {
                    fs = (Object[])value;
                    for (Object e : fs) {
                        OafNavigator2.navigate(e, mapping);
                    }
                    continue;
                }
                Function<Object, Object> cleaningFn = mapping.get(value.getClass());
                if (!Objects.nonNull(cleaningFn) || Objects.equals(value, newValue = cleaningFn.apply(value))) continue;
                field.set(o, newValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper;
    }

    private static boolean isPrimitive(Object o) {
        return o.getClass().isPrimitive() || o instanceof Class || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Long || o instanceof Boolean || o instanceof String || o instanceof Byte;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        return OafNavigator2.getAllFields(new LinkedList<Field>(), clazz);
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (Objects.nonNull(superclass) && superclass.getPackage().equals(Oaf.class.getPackage())) {
            OafNavigator2.getAllFields(fields, superclass);
        }
        return fields;
    }
}

