/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import com.google.common.collect.Maps;
import eu.dnetlib.dhp.oa.graph.raw.common.OafMapperUtils;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyTerm;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Vocabulary
implements Serializable {
    private final String id;
    private final String name;
    private final Map<String, VocabularyTerm> terms = new HashMap<String, VocabularyTerm>();
    private final Map<String, String> synonyms = Maps.newHashMap();

    public Vocabulary(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected Map<String, VocabularyTerm> getTerms() {
        return this.terms;
    }

    public VocabularyTerm getTerm(String id) {
        return Optional.ofNullable(id).map(s -> s.toLowerCase()).map(s -> this.terms.get(s)).orElse(null);
    }

    protected void addTerm(String id, String name) {
        this.terms.put(id.toLowerCase(), new VocabularyTerm(id, name));
    }

    protected boolean termExists(String id) {
        return this.terms.containsKey(id.toLowerCase());
    }

    protected void addSynonym(String syn, String termCode) {
        this.synonyms.put(syn, termCode.toLowerCase());
    }

    public VocabularyTerm getTermBySynonym(String syn) {
        return this.getTerm(this.synonyms.get(syn));
    }

    public Qualifier getTermAsQualifier(String termId) {
        if (StringUtils.isBlank((CharSequence)termId)) {
            return OafMapperUtils.unknown(this.getId(), this.getName());
        }
        if (this.termExists(termId)) {
            VocabularyTerm t = this.getTerm(termId);
            return OafMapperUtils.qualifier(t.getId(), t.getName(), this.getId(), this.getName());
        }
        return OafMapperUtils.qualifier(termId, termId, this.getId(), this.getName());
    }

    public Qualifier getSynonymAsQualifier(String syn) {
        return Optional.ofNullable(this.getTermBySynonym(syn)).map(term -> this.getTermAsQualifier(term.getId())).orElse(null);
    }
}

