/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.sx.graph.parser.DatasetScholexplorerParser;
import eu.dnetlib.dhp.sx.graph.parser.PublicationScholexplorerParser;
import eu.dnetlib.scholexplorer.relation.RelationMapper;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class SparkScholexplorerGraphImporter {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkScholexplorerGraphImporter.class.getResourceAsStream("/eu/dnetlib/dhp/sx/graph/argumentparser/input_graph_scholix_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(SparkScholexplorerGraphImporter.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        String inputPath = parser.get("sourcePath");
        RelationMapper relationMapper = RelationMapper.load();
        sc.sequenceFile(inputPath, IntWritable.class, Text.class).map(Tuple2::_2).map(Text::toString).repartition(500).flatMap((FlatMapFunction & Serializable)record -> {
            switch (parser.get("entity")) {
                case "dataset": {
                    DatasetScholexplorerParser d = new DatasetScholexplorerParser();
                    return d.parseObject((String)record, relationMapper).iterator();
                }
                case "publication": {
                    PublicationScholexplorerParser p = new PublicationScholexplorerParser();
                    return p.parseObject((String)record, relationMapper).iterator();
                }
            }
            throw new IllegalArgumentException("wrong values of entities");
        }).map((Function & Serializable)k -> {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(k);
        }).saveAsTextFile(parser.get("targetPath"), GzipCodec.class);
    }
}

