/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.oa.graph.clean.CleaningRuleMap;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class OafCleaner
implements Serializable {
    public static <E extends Oaf> E apply(E oaf, CleaningRuleMap mapping) {
        try {
            OafCleaner.navigate(oaf, mapping);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return oaf;
    }

    private static void navigate(Object o, CleaningRuleMap mapping) throws IllegalAccessException {
        if (OafCleaner.isPrimitive(o)) {
            return;
        }
        if (OafCleaner.isIterable(o.getClass())) {
            for (Object elem : (Iterable)o) {
                OafCleaner.navigate(elem, mapping);
            }
        } else if (OafCleaner.hasMapping(o, mapping)) {
            ((FunctionalInterfaceSupport.SerializableConsumer)mapping.get(o.getClass())).accept(o);
        } else {
            for (Field f : OafCleaner.getAllFields(o.getClass())) {
                f.setAccessible(true);
                Object val = f.get(o);
                if (!OafCleaner.isPrimitive(val) && OafCleaner.hasMapping(val, mapping)) {
                    ((FunctionalInterfaceSupport.SerializableConsumer)mapping.get(val.getClass())).accept(val);
                    continue;
                }
                OafCleaner.navigate(f.get(o), mapping);
            }
        }
    }

    private static boolean hasMapping(Object o, CleaningRuleMap mapping) {
        return mapping.containsKey(o.getClass());
    }

    private static boolean isIterable(Class<?> cl) {
        return Iterable.class.isAssignableFrom(cl);
    }

    private static boolean isPrimitive(Object o) {
        return Objects.isNull(o) || o.getClass().isPrimitive() || o instanceof Class || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Long || o instanceof Boolean || o instanceof String || o instanceof Byte;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        return OafCleaner.getAllFields(new LinkedList<Field>(), clazz);
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (Objects.nonNull(superclass) && superclass.getPackage().equals(Oaf.class.getPackage())) {
            OafCleaner.getAllFields(fields, superclass);
        }
        return fields;
    }
}

