/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.parser;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.dhp.parser.utility.VtdUtilityParser;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.scholexplorer.DLIDataset;
import eu.dnetlib.dhp.schema.scholexplorer.ProvenaceInfo;
import eu.dnetlib.dhp.sx.graph.parser.AbstractScholexplorerParser;
import eu.dnetlib.scholexplorer.relation.RelationMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DatasetScholexplorerParser
extends AbstractScholexplorerParser {
    @Override
    public List<Oaf> parseObject(String record, RelationMapper relationMapper) {
        try {
            List dates;
            List titles;
            DLIDataset parsedObject = new DLIDataset();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            ArrayList<Oaf> result = new ArrayList<Oaf>();
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            DataInfo di = new DataInfo();
            di.setTrust("0.9");
            di.setDeletedbyinference(Boolean.valueOf(false));
            di.setInvisible(Boolean.valueOf(false));
            parsedObject.setDataInfo(di);
            parsedObject.setOriginalId(Collections.singletonList(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='recordIdentifier']")));
            parsedObject.setOriginalObjIdentifier(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='objIdentifier']"));
            String dateOfCollection = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='dateOfCollection']");
            parsedObject.setDateofcollection(dateOfCollection);
            String resolvedDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resolvedDate']");
            if (StringUtils.isNotBlank((CharSequence)resolvedDate)) {
                StructuredProperty currentDate = new StructuredProperty();
                currentDate.setValue(resolvedDate);
                Qualifier dateQualifier = new Qualifier();
                dateQualifier.setClassname("resolvedDate");
                dateQualifier.setClassid("resolvedDate");
                dateQualifier.setSchemename("dnet::date");
                dateQualifier.setSchemeid("dnet::date");
                currentDate.setQualifier(dateQualifier);
                parsedObject.setRelevantdate(Collections.singletonList(currentDate));
            }
            String completionStatus = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='completionStatus']");
            String provisionMode = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='provisionMode']");
            String publisher = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='publisher']");
            List collectedFromNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='collectedFrom']", Arrays.asList("name", "id", "mode", "completionStatus"));
            List resolvededFromNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resolvedFrom']", Arrays.asList("name", "id", "mode", "completionStatus"));
            Field pf = new Field();
            pf.setValue((Object)publisher);
            parsedObject.setPublisher(pf);
            ArrayList provenances = new ArrayList();
            if (collectedFromNodes != null && collectedFromNodes.size() > 0) {
                collectedFromNodes.forEach(it -> {
                    ProvenaceInfo provenance = new ProvenaceInfo();
                    provenance.setId((String)it.getAttributes().get("id"));
                    provenance.setName((String)it.getAttributes().get("name"));
                    provenance.setCollectionMode(provisionMode);
                    provenance.setCompletionStatus((String)it.getAttributes().get("completionStatus"));
                    provenances.add(provenance);
                });
            }
            if (resolvededFromNodes != null && resolvededFromNodes.size() > 0) {
                resolvededFromNodes.forEach(it -> {
                    ProvenaceInfo provenance = new ProvenaceInfo();
                    provenance.setId((String)it.getAttributes().get("id"));
                    provenance.setName((String)it.getAttributes().get("name"));
                    provenance.setCollectionMode("resolved");
                    provenance.setCompletionStatus((String)it.getAttributes().get("completionStatus"));
                    provenances.add(provenance);
                });
            }
            parsedObject.setDlicollectedfrom(provenances);
            parsedObject.setCollectedfrom(parsedObject.getDlicollectedfrom().stream().map(p -> {
                KeyValue cf = new KeyValue();
                cf.setKey(p.getId());
                cf.setValue(p.getName());
                return cf;
            }).collect(Collectors.toList()));
            parsedObject.setCompletionStatus(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='completionStatus']"));
            List identifierType = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='identifier']", Collections.singletonList("identifierType"));
            StructuredProperty currentPid = this.extractIdentifier(identifierType, "identifierType");
            if (currentPid == null) {
                return null;
            }
            this.inferPid(currentPid);
            parsedObject.setPid(Collections.singletonList(currentPid));
            String sourceId = this.generateId(currentPid.getValue(), currentPid.getQualifier().getClassid(), "dataset");
            parsedObject.setId(sourceId);
            List descs = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='description']");
            if (descs != null && descs.size() > 0) {
                parsedObject.setDescription(descs.stream().map(it -> {
                    Field d = new Field();
                    d.setValue(it);
                    return d;
                }).collect(Collectors.toList()));
            }
            List relatedIdentifiers = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='relatedIdentifier']", Arrays.asList("relatedIdentifierType", "relationType", "entityType", "inverseRelationType"));
            this.generateRelations(relationMapper, (Result)parsedObject, result, di, dateOfCollection, relatedIdentifiers);
            List hostedBy = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='hostedBy']", Arrays.asList("id", "name"));
            if (hostedBy != null) {
                parsedObject.setInstance(hostedBy.stream().map(it -> {
                    Instance i = new Instance();
                    i.setUrl(Collections.singletonList(currentPid.getValue()));
                    KeyValue h = new KeyValue();
                    i.setHostedby(h);
                    h.setKey((String)it.getAttributes().get("id"));
                    h.setValue((String)it.getAttributes().get("name"));
                    return i;
                }).collect(Collectors.toList()));
            }
            List<StructuredProperty> subjects = this.extractSubject(VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='subject']", Collections.singletonList("subjectScheme")));
            parsedObject.setSubject(subjects);
            Qualifier q = new Qualifier();
            q.setClassname("dataset");
            q.setClassid("dataset");
            q.setSchemename("dataset");
            q.setSchemeid("dataset");
            parsedObject.setResulttype(q);
            parsedObject.setCompletionStatus(completionStatus);
            List creators = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='creator']/*[local-name()='creatorName']");
            if (creators != null && creators.size() > 0) {
                parsedObject.setAuthor(creators.stream().map(a -> {
                    Author author = new Author();
                    author.setFullname(a);
                    return author;
                }).collect(Collectors.toList()));
            }
            if ((titles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='title']")) != null && titles.size() > 0) {
                parsedObject.setTitle(titles.stream().map(t -> {
                    StructuredProperty st = new StructuredProperty();
                    st.setValue(t);
                    return st;
                }).collect(Collectors.toList()));
            }
            if ((dates = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='dates']/*[local-name()='date']")) != null && dates.size() > 0) {
                parsedObject.setRelevantdate(dates.stream().map(cd -> {
                    StructuredProperty date = new StructuredProperty();
                    date.setValue(cd);
                    Qualifier dq = new Qualifier();
                    dq.setClassname("date");
                    dq.setClassid("date");
                    dq.setSchemename("dnet::date");
                    dq.setSchemeid("dnet::date");
                    date.setQualifier(dq);
                    return date;
                }).collect(Collectors.toList()));
            }
            result.add((Oaf)parsedObject);
            return result;
        }
        catch (Throwable e) {
            log.error((Object)("Error on parsing record " + record), e);
            return null;
        }
    }
}

