/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.oa.graph.raw.common.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class CleaningRuleMap
extends HashMap<Class, FunctionalInterfaceSupport.SerializableConsumer<Object>>
implements Serializable {
    public static CleaningRuleMap create(VocabularyGroup vocabularies) {
        CleaningRuleMap mapping = new CleaningRuleMap();
        mapping.put(Qualifier.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> CleaningRuleMap.cleanQualifier(vocabularies, (Qualifier)o));
        mapping.put(Country.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> {
            Country c = (Country)o;
            if (StringUtils.isBlank((CharSequence)c.getSchemeid())) {
                c.setSchemeid("dnet:countries");
                c.setSchemename("dnet:countries");
            }
            CleaningRuleMap.cleanQualifier(vocabularies, c);
        });
        return mapping;
    }

    private static <Q extends Qualifier> void cleanQualifier(VocabularyGroup vocabularies, Q q) {
        if (vocabularies.vocabularyExists(q.getSchemeid())) {
            Qualifier newValue = vocabularies.lookup(q.getSchemeid(), q.getClassid());
            q.setClassid(newValue.getClassid());
            q.setClassname(newValue.getClassname());
        }
    }
}

