/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ImportDataFromMongo {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)ImportDataFromMongo.class.getResourceAsStream("/eu/dnetlib/dhp/sx/graph/argumentparser/import_from_mongo_parameters.json")));
        parser.parseArgument(args);
        int port = Integer.parseInt(parser.get("dbport"));
        String host = parser.get("dbhost");
        String format = parser.get("format");
        String layout = parser.get("layout");
        String interpretation = parser.get("interpretation");
        String dbName = parser.get("dbName");
        MongoClient client = new MongoClient(host, port);
        MongoDatabase database = client.getDatabase(dbName);
        MongoCollection metadata = database.getCollection("metadata");
        MongoCollection metadataManager = database.getCollection("metadataManager");
        DBObject query = QueryBuilder.start((String)"format").is((Object)format).and("layout").is((Object)layout).and("interpretation").is((Object)interpretation).get();
        ArrayList ids = new ArrayList();
        metadata.find((Bson)query).forEach(document -> ids.add(document.getString((Object)"mdId")));
        List<String> databaseId = ids.stream().map(it -> ImportDataFromMongo.getCurrentId(it, (MongoCollection<Document>)metadataManager)).filter(Objects::nonNull).collect(Collectors.toList());
        String hdfsuri = parser.get("namenode");
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsuri);
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        FileSystem.get((URI)URI.create(hdfsuri), (Configuration)conf);
        Path hdfswritepath = new Path(parser.get("targetPath"));
        AtomicInteger counter = new AtomicInteger(0);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)hdfswritepath), SequenceFile.Writer.keyClass(IntWritable.class), SequenceFile.Writer.valueClass(Text.class)});){
            IntWritable key = new IntWritable(counter.get());
            Text value = new Text();
            databaseId.forEach(id -> {
                System.out.println("Reading :" + id);
                MongoCollection collection = database.getCollection(id);
                collection.find().forEach(document -> {
                    key.set(counter.getAndIncrement());
                    value.set(document.getString((Object)"body"));
                    if (counter.get() % 10000 == 0) {
                        System.out.println("Added " + counter.get());
                    }
                    try {
                        writer.append((Writable)key, (Writable)value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            });
        }
    }

    private static String getCurrentId(String mdId, MongoCollection<Document> metadataManager) {
        FindIterable result = metadataManager.find((Bson)QueryBuilder.start((String)"mdId").is((Object)mdId).get());
        Document item = (Document)result.first();
        return item == null ? null : item.getString((Object)"currentId");
    }
}

