/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkConvertRDDtoDataset$ {
    public static final SparkConvertRDDtoDataset$ MODULE$;

    static {
        new SparkConvertRDDtoDataset$();
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/convert_dataset_json_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master(parser.get("master")).getOrCreate();
        String sourcePath = parser.get("sourcePath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourcePath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})));
        String t = parser.get("targetPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targetPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t})));
        String subRelTypeFilter = parser.get("filterRelation");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filterRelation  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subRelTypeFilter})));
        String entityPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/entities"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
        String relPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/relation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
        ObjectMapper mapper = new ObjectMapper();
        Encoder datasetEncoder = Encoders$.MODULE$.kryo(Dataset.class);
        Encoder publicationEncoder = Encoders$.MODULE$.kryo(Publication.class);
        Encoder relationEncoder = Encoders$.MODULE$.kryo(Relation.class);
        Encoder orpEncoder = Encoders$.MODULE$.kryo(OtherResearchProduct.class);
        Encoder softwareEncoder = Encoders$.MODULE$.kryo(Software.class);
        log.info("Converting dataset");
        RDD rddDataset = spark.sparkContext().textFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/dataset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})), spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Dataset apply(String s) {
                return (Dataset)this.mapper$1.readValue(s, Dataset.class);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, ClassTag$.MODULE$.apply(Dataset.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dataset r) {
                return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        });
        spark.createDataset(rddDataset, datasetEncoder).as(datasetEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/dataset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityPath})));
        log.info("Converting publication");
        RDD rddPublication = spark.sparkContext().textFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/publication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})), spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Publication apply(String s) {
                return (Publication)this.mapper$1.readValue(s, Publication.class);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, ClassTag$.MODULE$.apply(Publication.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Publication r) {
                return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        });
        spark.createDataset(rddPublication, publicationEncoder).as(publicationEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/publication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityPath})));
        log.info("Converting software");
        RDD rddSoftware = spark.sparkContext().textFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/software"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})), spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Software apply(String s) {
                return (Software)this.mapper$1.readValue(s, Software.class);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, ClassTag$.MODULE$.apply(Software.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Software r) {
                return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        });
        spark.createDataset(rddSoftware, softwareEncoder).as(softwareEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/software"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityPath})));
        log.info("Converting otherresearchproduct");
        RDD rddOtherResearchProduct = spark.sparkContext().textFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/otherresearchproduct"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})), spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final OtherResearchProduct apply(String s) {
                return (OtherResearchProduct)this.mapper$1.readValue(s, OtherResearchProduct.class);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, ClassTag$.MODULE$.apply(OtherResearchProduct.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OtherResearchProduct r) {
                return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        });
        spark.createDataset(rddOtherResearchProduct, orpEncoder).as(orpEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/otherresearchproduct"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityPath})));
        log.info("Converting Relation");
        List relClassFilter = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"merges", "isMergedIn", "HasAmongTopNSimilarDocuments", "IsAmongTopNSimilarDocuments"}));
        RDD rddRelation = spark.sparkContext().textFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/relation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})), spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Relation apply(String s) {
                return (Relation)this.mapper$1.readValue(s, Relation.class);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, ClassTag$.MODULE$.apply(Relation.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Relation r) {
                return r.getDataInfo() != null && !Predef$.MODULE$.Boolean2boolean(r.getDataInfo().getDeletedbyinference());
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Relation r) {
                return r.getSource().startsWith("50") && r.getTarget().startsWith("50");
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Relation r) {
                return SparkConvertRDDtoDataset$.MODULE$.eu$dnetlib$dhp$sx$graph$SparkConvertRDDtoDataset$$filterRelations(r);
            }
        });
        spark.createDataset(rddRelation, relationEncoder).as(relationEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relPath})));
    }

    public boolean eu$dnetlib$dhp$sx$graph$SparkConvertRDDtoDataset$$filterRelations(Relation r) {
        List relClassFilter = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"merges", "isMergedIn", "HasAmongTopNSimilarDocuments", "IsAmongTopNSimilarDocuments"}));
        return relClassFilter.exists((Function1)new Serializable(r){
            public static final long serialVersionUID = 0L;
            private final Relation r$1;

            public final boolean apply(String k) {
                return k.equalsIgnoreCase(this.r$1.getRelClass());
            }
            {
                this.r$1 = r$1;
            }
        }) ? false : (r.getCollectedfrom() == null || r.getCollectedfrom().size() == 0 ? false : (r.getCollectedfrom().size() > 1 ? true : r.getCollectedfrom().size() != 1 || r.getCollectedfrom().get(0) == null || !"OpenCitations".equalsIgnoreCase(((KeyValue)r.getCollectedfrom().get(0)).getValue())));
    }

    private SparkConvertRDDtoDataset$() {
        MODULE$ = this;
    }
}

