/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.common.PacePerson;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.AbstractMdRecordToOafMapper;
import eu.dnetlib.dhp.oa.graph.raw.OriginalTypeComparator;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.CleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class OafToOafMapper
extends AbstractMdRecordToOafMapper {
    private static Set<String> DC_TYPE_PUBLICATION_VERSION = new HashSet<String>();

    public OafToOafMapper(VocabularyGroup vocs, boolean invisible, boolean shouldHashId, boolean forceOrginalId) {
        super(vocs, invisible, shouldHashId, forceOrginalId);
    }

    public OafToOafMapper(VocabularyGroup vocs, boolean invisible, boolean shouldHashId) {
        super(vocs, invisible, shouldHashId);
    }

    @Override
    protected List<Author> prepareAuthors(Document doc, DataInfo info) {
        ArrayList<Author> res = new ArrayList<Author>();
        int pos = 1;
        for (Object o : doc.selectNodes("//dc:creator")) {
            Element e = (Element)o;
            Author author = new Author();
            author.setFullname(e.getText());
            author.setRank(Integer.valueOf(pos++));
            PacePerson p = new PacePerson(e.getText(), false);
            if (p.isAccurate()) {
                author.setName(p.getNormalisedFirstName());
                author.setSurname(p.getNormalisedSurname());
            }
            String pid = e.valueOf("./@nameIdentifier");
            String type = e.valueOf("./@nameIdentifierScheme").trim().toUpperCase().replace(" ", "").replace("_", "");
            author.setPid(new ArrayList());
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                if (type.toLowerCase().startsWith("orcid")) {
                    String cleanedId = pid.replaceAll("http://orcid.org/", "").replaceAll("https://orcid.org/", "");
                    author.getPid().add(OafMapperUtils.structuredProperty((String)cleanedId, (Qualifier)ORCID_PID_TYPE, (DataInfo)info));
                } else if (type.startsWith("MAGID")) {
                    author.getPid().add(OafMapperUtils.structuredProperty((String)pid, (Qualifier)MAG_PID_TYPE, (DataInfo)info));
                }
            }
            res.add(author);
        }
        return res;
    }

    @Override
    protected Qualifier prepareLanguages(Document doc) {
        return this.prepareQualifier((Node)doc, "//dc:language", "dnet:languages");
    }

    @Override
    protected List<Subject> prepareSubjects(Document doc, DataInfo info) {
        return this.prepareSubjectList((Node)doc, "//dc:subject", info);
    }

    @Override
    protected List<StructuredProperty> prepareTitles(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:title", ModelConstants.MAIN_TITLE_QUALIFIER, info);
    }

    @Override
    protected List<Field<String>> prepareDescriptions(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:description", info).stream().map(d -> {
            d.setValue((Object)StringUtils.left((String)((String)d.getValue()), (int)150000));
            return d;
        }).collect(Collectors.toList());
    }

    @Override
    protected Field<String> preparePublisher(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:publisher", info);
    }

    @Override
    protected List<Field<String>> prepareFormats(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:format", info);
    }

    @Override
    protected List<Field<String>> prepareContributors(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:contributor", info);
    }

    @Override
    protected List<Field<String>> prepareCoverages(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:coverage", info);
    }

    @Override
    protected List<Instance> prepareInstances(Document doc, DataInfo info, KeyValue collectedfrom, KeyValue hostedby) {
        Instance instance = new Instance();
        instance.setInstancetype(this.prepareQualifier((Node)doc, "//dr:CobjCategory", "dnet:publication_resource"));
        instance.setCollectedfrom(collectedfrom);
        instance.setHostedby(hostedby);
        List<StructuredProperty> alternateIdentifier = this.prepareResultPids(doc, info);
        List pid = IdentifierFactory.getPids(alternateIdentifier, (KeyValue)collectedfrom);
        instance.setInstanceTypeMapping(this.prepareInstanceTypeMapping(doc));
        HashSet pids = new HashSet(pid);
        instance.setAlternateIdentifier(alternateIdentifier.stream().filter(i -> !pids.contains(i)).collect(Collectors.toList()));
        instance.setPid(pid);
        instance.setDateofacceptance(OafMapperUtils.field((Object)doc.valueOf("//oaf:dateAccepted"), (DataInfo)info));
        instance.setDistributionlocation(doc.valueOf("//oaf:distributionlocation"));
        instance.setAccessright(this.prepareAccessRight((Node)doc, "//oaf:accessrights", "dnet:access_modes"));
        instance.setLicense(OafMapperUtils.field((Object)doc.valueOf("//oaf:license"), (DataInfo)info));
        instance.setRefereed(this.prepareQualifier((Node)doc, "//oaf:refereed", "dnet:review_levels"));
        instance.setProcessingchargeamount(OafMapperUtils.field((Object)doc.valueOf("//oaf:processingchargeamount"), (DataInfo)info));
        instance.setProcessingchargecurrency(OafMapperUtils.field((Object)doc.valueOf("//oaf:processingchargeamount/@currency"), (DataInfo)info));
        this.prepareListURL((Node)doc, "//oaf:fulltext", info).stream().findFirst().map(Field::getValue).ifPresent(arg_0 -> ((Instance)instance).setFulltext(arg_0));
        ArrayList nodes = Lists.newArrayList((Iterable)doc.selectNodes("//dc:identifier"));
        List url = nodes.stream().filter(n -> StringUtils.isNotBlank((CharSequence)n.getText())).map(n -> n.getText().trim()).filter(u -> u.startsWith("http")).map(s -> {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (Throwable t) {
                return s;
            }
        }).distinct().collect(Collectors.toCollection(ArrayList::new));
        Set<String> validUrl = this.validateUrl(url);
        if (!validUrl.isEmpty()) {
            instance.setUrl(new ArrayList());
            instance.getUrl().addAll(validUrl);
        }
        return Lists.newArrayList((Object[])new Instance[]{instance});
    }

    @Override
    protected String findOriginalType(Document doc) {
        String dcType = doc.selectNodes("//dc:type").stream().map(o -> "" + ((Node)o).getText().trim()).filter(t -> !DC_TYPE_PUBLICATION_VERSION.contains(t)).sorted(new OriginalTypeComparator()).findFirst().orElse(null);
        String drCobjCategory = doc.valueOf("//dr:CobjCategory/text()");
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{dcType, drCobjCategory});
    }

    @Override
    protected List<Field<String>> prepareSources(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:source", info);
    }

    @Override
    protected List<StructuredProperty> prepareRelevantDates(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected Qualifier prepareSoftwareProgrammingLanguage(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareSoftwareCodeRepositoryUrl(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareSoftwareLicenses(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected List<Field<String>> prepareSoftwareDocumentationUrls(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<GeoLocation> prepareDatasetGeoLocations(Document doc, DataInfo info) {
        return new ArrayList<GeoLocation>();
    }

    @Override
    protected Field<String> prepareDatasetMetadataVersionNumber(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetLastMetadataUpdate(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetVersion(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetSize(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetDevice(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetStorageDate(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductTools(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactGroups(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactPersons(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Oaf> addOtherResultRels(Document doc, OafEntity entity, DataInfo info) {
        String docId = entity.getId();
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        for (Object o : doc.selectNodes("//*[local-name()='relatedDataset']")) {
            String originalId = ((Node)o).getText();
            if (!StringUtils.isNotBlank((CharSequence)originalId)) continue;
            String otherId = OafMapperUtils.createOpenaireId((int)50, (String)originalId, (boolean)false);
            res.add((Oaf)OafMapperUtils.getRelation((String)docId, (String)otherId, (String)"resultResult", (String)"relationship", (String)"IsRelatedTo", (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), null, null));
            res.add((Oaf)OafMapperUtils.getRelation((String)otherId, (String)docId, (String)"resultResult", (String)"relationship", (String)"IsRelatedTo", (List)entity.getCollectedfrom(), (DataInfo)info, (Long)entity.getLastupdatetimestamp(), null, null));
        }
        return res;
    }

    @Override
    protected Qualifier prepareResourceType(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareResultPids(Document doc, DataInfo info) {
        return this.prepareListStructPropsWithValidQualifier((Node)doc, "//oaf:identifier", "@identifierType", "dnet:pid_types", info).stream().map(CleaningFunctions::normalizePidValue).collect(Collectors.toList());
    }

    static {
        DC_TYPE_PUBLICATION_VERSION.add("info:eu-repo/semantics/submittedVersion");
        DC_TYPE_PUBLICATION_VERSION.add("info:eu-repo/semantics/acceptedVersion");
        DC_TYPE_PUBLICATION_VERSION.add("info:eu-repo/semantics/publishedVersion");
        DC_TYPE_PUBLICATION_VERSION.add("info:eu-repo/semantics/updatedVersion");
    }
}

