/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.common.vocabulary.VocabularyTerm;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Subject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CleaningRuleMap
extends HashMap<Class<?>, FunctionalInterfaceSupport.SerializableConsumer<Object>>
implements Serializable {
    public static CleaningRuleMap create(VocabularyGroup vocabularies) {
        CleaningRuleMap mapping = new CleaningRuleMap();
        mapping.put(Qualifier.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> CleaningRuleMap.cleanQualifier(vocabularies, (Qualifier)o));
        mapping.put(AccessRight.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> CleaningRuleMap.cleanQualifier(vocabularies, (AccessRight)o));
        mapping.put(Country.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> CleaningRuleMap.cleanCountry(vocabularies, (Country)o));
        mapping.put(Relation.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> CleaningRuleMap.cleanRelation(vocabularies, (Relation)o));
        mapping.put(Subject.class, (FunctionalInterfaceSupport.SerializableConsumer & Serializable)o -> CleaningRuleMap.cleanSubject(vocabularies, (Subject)o));
        return mapping;
    }

    private static void cleanSubject(VocabularyGroup vocabularies, Subject subject) {
        CleaningRuleMap.cleanSubjectForVocabulary("FOS", vocabularies, subject);
    }

    private static void cleanSubjectForVocabulary(String vocabularyId, VocabularyGroup vocabularies, Subject subject) {
        vocabularies.find(vocabularyId).ifPresent(vocabulary -> {
            if ("keyword".equalsIgnoreCase(subject.getQualifier().getClassid())) {
                Qualifier newValue = vocabulary.lookup(subject.getValue(), true);
                if (!"UNKNOWN".equals(newValue.getClassid())) {
                    subject.setValue(newValue.getClassid());
                    subject.getQualifier().setClassid(vocabularyId);
                    subject.getQualifier().setClassname(vocabulary.getName());
                }
            } else if (vocabularyId.equals(subject.getQualifier().getClassid()) && Objects.nonNull(subject.getDataInfo()) && !"subject:fos".equals(subject.getDataInfo().getProvenanceaction())) {
                Qualifier syn = vocabulary.getSynonymAsQualifier(subject.getValue());
                VocabularyTerm term = vocabulary.getTerm(subject.getValue());
                if (Objects.isNull(syn) && Objects.isNull(term)) {
                    subject.getQualifier().setClassid("keyword");
                    subject.getQualifier().setClassname("keyword");
                }
            }
        });
    }

    private static void cleanRelation(VocabularyGroup vocabularies, Relation r) {
        Qualifier newValue;
        if (vocabularies.vocabularyExists("dnet:relation_subRelType")) {
            newValue = vocabularies.lookup("dnet:relation_subRelType", r.getSubRelType());
            r.setSubRelType(newValue.getClassid());
        }
        if (vocabularies.vocabularyExists("dnet:relation_relClass")) {
            newValue = vocabularies.lookup("dnet:relation_relClass", r.getRelClass());
            r.setRelClass(newValue.getClassid());
        }
    }

    private static void cleanCountry(VocabularyGroup vocabularies, Country o) {
        Country c = o;
        if (StringUtils.isBlank((CharSequence)c.getSchemeid())) {
            c.setSchemeid("dnet:countries");
            c.setSchemename("dnet:countries");
        }
        CleaningRuleMap.cleanQualifier(vocabularies, c);
    }

    private static <Q extends Qualifier> void cleanQualifier(VocabularyGroup vocabularies, Q q) {
        if (vocabularies.vocabularyExists(q.getSchemeid())) {
            Qualifier newValue = vocabularies.lookup(q.getSchemeid(), q.getClassid());
            q.setClassid(newValue.getClassid());
            q.setClassname(newValue.getClassname());
        }
    }
}

