/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.oa.graph.raw.CopyHdfsOafSparkApplication$;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class CopyHdfsOafSparkApplication$ {
    public static final CopyHdfsOafSparkApplication$ MODULE$;

    static {
        new CopyHdfsOafSparkApplication$();
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/copy_hdfs_oaf_parameters.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString());
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master(parser.get("master")).getOrCreate();
        SparkContext sc = spark.sparkContext();
        String mdstoreManagerUrl = parser.get("mdstoreManagerUrl");
        log.info("mdstoreManagerUrl: {}", new Object[]{mdstoreManagerUrl});
        String mdFormat = parser.get("mdFormat");
        log.info("mdFormat: {}", new Object[]{mdFormat});
        String mdLayout = parser.get("mdLayout");
        log.info("mdLayout: {}", new Object[]{mdLayout});
        String mdInterpretation = parser.get("mdInterpretation");
        log.info("mdInterpretation: {}", new Object[]{mdInterpretation});
        String hdfsPath = parser.get("hdfsPath");
        log.info("hdfsPath: {}", new Object[]{hdfsPath});
        Encoder oafEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Oaf.class));
        Set paths = (Set)JavaConverters$.MODULE$.asScalaSetConverter(DHPUtils.mdstorePaths((String)mdstoreManagerUrl, (String)mdFormat, (String)mdLayout, (String)mdInterpretation, (boolean)true)).asScala();
        List validPaths = ((TraversableOnce)paths.filter((Function1)new Serializable(sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;

            public final boolean apply(String p) {
                return HdfsSupport.exists((String)p, (Configuration)this.sc$1.hadoopConfiguration());
            }
            {
                this.sc$1 = sc$1;
            }
        })).toList();
        Set types = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(ModelSupport.oafTypes.entrySet()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Class<Object>> apply(Map.Entry<String, Class<?>> e) {
                return new Tuple2((Object)e.getKey(), e.getValue());
            }
        }, Set$.MODULE$.canBuildFrom());
        if (validPaths.nonEmpty()) {
            Dataset oaf = spark.read().textFile((Seq)validPaths);
            ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            types.foreach((Function1)new Serializable(hdfsPath, oafEncoder, oaf, mapper){
                public static final long serialVersionUID = 0L;
                private final String hdfsPath$1;
                private final Encoder oafEncoder$1;
                private final Dataset oaf$1;
                public final ObjectMapper mapper$1;

                public final void apply(Tuple2<String, Class<Object>> t) {
                    this.oaf$1.filter((Function1)new Serializable(this, t){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 t$1;

                        public final boolean apply(String o) {
                            return CopyHdfsOafSparkApplication$.MODULE$.isOafType(o, (String)this.t$1._1());
                        }
                        {
                            this.t$1 = t$1;
                        }
                    }).map((Function1)new Serializable(this, t){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.1 $outer;
                        private final Tuple2 t$1;

                        public final Oaf apply(String j) {
                            return (Oaf)this.$outer.mapper$1.readValue(j, (Class)this.t$1._2());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.t$1 = t$1;
                        }
                    }, this.oafEncoder$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.1 $outer;

                        public final String apply(Oaf s) {
                            return this.$outer.mapper$1.writeValueAsString((Object)s);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Encoders$.MODULE$.STRING()).write().option("compression", "gzip").mode(SaveMode.Append).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hdfsPath$1, t._1()})));
                }
                {
                    this.hdfsPath$1 = hdfsPath$1;
                    this.oafEncoder$1 = oafEncoder$1;
                    this.oaf$1 = oaf$1;
                    this.mapper$1 = mapper$1;
                }
            });
        }
    }

    public boolean isOafType(String input, String oafType) {
        boolean bl;
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String string = oafType;
        String string2 = "relation";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String hasSource = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash("source")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            String hasTarget = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash("target")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            bl = hasSource != null && hasTarget != null;
        } else {
            String hasId = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash("id")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            String resultType = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash("resulttype")).$bslash("classid")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }, (Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            bl = hasId != null && oafType.startsWith(resultType);
        }
        return bl;
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        CopyHdfsOafSparkApplication$ copyHdfsOafSparkApplication$ = this;
        synchronized (copyHdfsOafSparkApplication$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        CopyHdfsOafSparkApplication$ copyHdfsOafSparkApplication$ = this;
        synchronized (copyHdfsOafSparkApplication$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private CopyHdfsOafSparkApplication$() {
        MODULE$ = this;
    }
}

