/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.MigrateDbEntitiesApplication;
import eu.dnetlib.dhp.oa.graph.raw.TypedField;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class MigrateDbEntitiesApplicationTest {
    private MigrateDbEntitiesApplication app;
    @Mock(lenient=true)
    private ResultSet rs;
    @Mock
    private VocabularyGroup vocs;

    MigrateDbEntitiesApplicationTest() {
    }

    @BeforeEach
    public void setUp() {
        Mockito.lenient().when((Object)this.vocs.getTermAsQualifier(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(invocation -> OafMapperUtils.qualifier((String)((String)invocation.getArgument(1)), (String)((String)invocation.getArgument(1)), (String)((String)invocation.getArgument(0)), (String)((String)invocation.getArgument(0))));
        Mockito.lenient().when((Object)this.vocs.termExists(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.app = new MigrateDbEntitiesApplication(this.vocs);
    }

    @Test
    void testProcessService() throws Exception {
        List<TypedField> fields = this.prepareMocks("services_resultset_entry.json");
        List list = this.app.processService(this.rs);
        Assertions.assertEquals((int)1, (int)list.size());
        this.verifyMocks(fields);
        Datasource ds = (Datasource)list.get(0);
        this.assertValidId(ds.getId());
        ds.getCollectedfrom().stream().map(KeyValue::getKey).forEach(this::assertValidId);
        Assertions.assertEquals((int)1, (int)ds.getPid().size());
        Assertions.assertEquals((Object)"r3d100010218", (Object)((StructuredProperty)ds.getPid().get(0)).getValue());
        Assertions.assertEquals((Object)"re3data", (Object)((StructuredProperty)ds.getPid().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)((StructuredProperty)ds.getPid().get(0)).getQualifier().getSchemeid());
        Assertions.assertEquals((Object)this.getValueAsString("officialname", fields), (Object)ds.getOfficialname().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("englishname", fields), (Object)ds.getEnglishname().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("websiteurl", fields), (Object)ds.getWebsiteurl().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("logourl", fields), (Object)ds.getLogourl());
        Assertions.assertEquals((Object)this.getValueAsString("contactemail", fields), (Object)ds.getContactemail().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("namespaceprefix", fields), (Object)ds.getNamespaceprefix().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("officialname", fields), (Object)ds.getJournal().getName());
        Assertions.assertEquals((Object)this.getValueAsString("issnPrinted", fields), (Object)ds.getJournal().getIssnPrinted());
        Assertions.assertEquals((Object)this.getValueAsString("issnOnline", fields), (Object)ds.getJournal().getIssnOnline());
        Assertions.assertEquals((Object)this.getValueAsString("issnLinking", fields), (Object)ds.getJournal().getIssnLinking());
        Assertions.assertEquals((Object)"pubsrepository::journal", (Object)ds.getDatasourcetype().getClassid());
        Assertions.assertEquals((Object)"dnet:datasource_typologies", (Object)ds.getDatasourcetype().getSchemeid());
        Assertions.assertEquals((Object)"pubsrepository::journal", (Object)ds.getDatasourcetypeui().getClassid());
        Assertions.assertEquals((Object)"dnet:datasource_typologies_ui", (Object)ds.getDatasourcetypeui().getSchemeid());
        Assertions.assertEquals((Object)"Data Source", (Object)ds.getEosctype().getClassid());
        Assertions.assertEquals((Object)"Data Source", (Object)ds.getEosctype().getClassname());
        Assertions.assertEquals((Object)"dnet:eosc_types", (Object)ds.getEosctype().getSchemeid());
        Assertions.assertEquals((Object)"dnet:eosc_types", (Object)ds.getEosctype().getSchemename());
        Assertions.assertEquals((Object)"Journal archive", (Object)ds.getEoscdatasourcetype().getClassid());
        Assertions.assertEquals((Object)"Journal archive", (Object)ds.getEoscdatasourcetype().getClassname());
        Assertions.assertEquals((Object)"dnet:eosc_datasource_types", (Object)ds.getEoscdatasourcetype().getSchemeid());
        Assertions.assertEquals((Object)"dnet:eosc_datasource_types", (Object)ds.getEoscdatasourcetype().getSchemename());
        Assertions.assertEquals((Object)"openaire4.0", (Object)ds.getOpenairecompatibility().getClassid());
        Assertions.assertEquals((Object)"openaire4.0", (Object)ds.getOpenairecompatibility().getClassname());
        Assertions.assertEquals((Object)"dnet:datasourceCompatibilityLevel", (Object)ds.getOpenairecompatibility().getSchemeid());
        Assertions.assertEquals((Object)"dnet:datasourceCompatibilityLevel", (Object)ds.getOpenairecompatibility().getSchemename());
        Assertions.assertEquals((Object)this.getValueAsDouble("latitude", fields).toString(), (Object)ds.getLatitude().getValue());
        Assertions.assertEquals((Object)this.getValueAsDouble("longitude", fields).toString(), (Object)ds.getLongitude().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("dateofvalidation", fields), (Object)ds.getDateofvalidation());
        Assertions.assertEquals((Object)this.getValueAsString("description", fields), (Object)ds.getDescription().getValue());
        Assertions.assertEquals((Object)"0.0", (Object)ds.getOdnumberofitems().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("odnumberofitemsdate", fields), (Object)ds.getOdnumberofitemsdate());
        Assertions.assertEquals((Object)this.getValueAsString("odpolicies", fields), (Object)ds.getOdpolicies());
        Assertions.assertEquals(this.getValueAsList("odlanguages", fields), ds.getOdlanguages().stream().map(Field::getValue).collect(Collectors.toList()));
        Assertions.assertEquals(this.getValueAsList("languages", fields), (Object)ds.getLanguages());
        Assertions.assertEquals(this.getValueAsList("accessinfopackage", fields), ds.getAccessinfopackage().stream().map(Field::getValue).collect(Collectors.toList()));
        Assertions.assertEquals((Object)this.getValueAsString("releasestartdate", fields), (Object)ds.getReleasestartdate());
        Assertions.assertEquals((Object)this.getValueAsString("releaseenddate", fields), (Object)ds.getReleasestartdate());
        Assertions.assertEquals((Object)this.getValueAsString("missionstatementurl", fields), (Object)ds.getMissionstatementurl());
        Assertions.assertEquals(null, (Object)ds.getDataprovider());
        Assertions.assertEquals(null, (Object)ds.getServiceprovider());
        Assertions.assertEquals((Object)this.getValueAsString("databaseaccesstype", fields), (Object)ds.getDatabaseaccesstype());
        Assertions.assertEquals((Object)this.getValueAsString("datauploadtype", fields), (Object)ds.getDatauploadtype());
        Assertions.assertEquals((Object)this.getValueAsString("databaseaccessrestriction", fields), (Object)ds.getDatabaseaccessrestriction());
        Assertions.assertEquals((Object)this.getValueAsString("datauploadrestriction", fields), (Object)ds.getDatauploadrestriction());
        Assertions.assertEquals((Object)false, (Object)ds.getVersioning().getValue());
        Assertions.assertEquals((Object)false, (Object)ds.getVersioncontrol());
        Assertions.assertEquals((Object)this.getValueAsString("citationguidelineurl", fields), (Object)ds.getCitationguidelineurl());
        Assertions.assertEquals((Object)this.getValueAsString("pidsystems", fields), (Object)ds.getPidsystems());
        Assertions.assertEquals((Object)this.getValueAsString("certificates", fields), (Object)ds.getCertificates());
        Assertions.assertEquals(this.getValueAsList("researchentitytypes", fields), (Object)ds.getResearchentitytypes());
        Assertions.assertEquals((Object)"National", (Object)ds.getJurisdiction().getClassid());
        Assertions.assertEquals((Object)"eosc:jurisdictions", (Object)ds.getJurisdiction().getSchemeid());
        Assertions.assertTrue((boolean)ds.getThematic());
        HashSet cpSchemeId = ds.getContentpolicies().stream().map(Qualifier::getSchemeid).collect(Collectors.toCollection(HashSet::new));
        Assertions.assertEquals((int)1, (int)cpSchemeId.size());
        Assertions.assertTrue((boolean)cpSchemeId.contains("eosc:contentpolicies"));
        HashSet cpSchemeName = ds.getContentpolicies().stream().map(Qualifier::getSchemename).collect(Collectors.toCollection(HashSet::new));
        Assertions.assertEquals((int)1, (int)cpSchemeName.size());
        Assertions.assertTrue((boolean)cpSchemeName.contains("eosc:contentpolicies"));
        Assertions.assertEquals((int)2, (int)ds.getContentpolicies().size());
        Assertions.assertEquals((Object)"Taxonomic classification", (Object)((Qualifier)ds.getContentpolicies().get(0)).getClassid());
        Assertions.assertEquals((Object)"Resource collection", (Object)((Qualifier)ds.getContentpolicies().get(1)).getClassid());
        Assertions.assertEquals((Object)this.getValueAsString("submissionpolicyurl", fields), (Object)ds.getSubmissionpolicyurl());
        Assertions.assertEquals((Object)this.getValueAsString("preservationpolicyurl", fields), (Object)ds.getPreservationpolicyurl());
        Assertions.assertEquals(this.getValueAsList("researchproductaccesspolicies", fields), (Object)ds.getResearchproductaccesspolicies());
        Assertions.assertEquals(this.getValueAsList("researchproductmetadataaccesspolicies", fields), (Object)ds.getResearchproductmetadataaccesspolicies());
        Assertions.assertEquals((Object)true, (Object)ds.getConsenttermsofuse());
        Assertions.assertEquals((Object)true, (Object)ds.getFulltextdownload());
        Assertions.assertEquals((Object)"2022-03-11", (Object)ds.getConsenttermsofusedate());
        Assertions.assertEquals((Object)"2022-03-11", (Object)ds.getLastconsenttermsofusedate());
    }

    @Test
    void testProcessProject() throws Exception {
        List<TypedField> fields = this.prepareMocks("projects_resultset_entry.json");
        List list = this.app.processProject(this.rs);
        Assertions.assertEquals((int)1, (int)list.size());
        this.verifyMocks(fields);
        Project p = (Project)list.get(0);
        this.assertValidId(p.getId());
        this.assertValidId(((KeyValue)p.getCollectedfrom().get(0)).getKey());
        Assertions.assertEquals((Object)this.getValueAsString("acronym", fields), (Object)p.getAcronym().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("title", fields), (Object)p.getTitle().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("collectedfromname", fields), (Object)((KeyValue)p.getCollectedfrom().get(0)).getValue());
        Assertions.assertEquals((Float)this.getValueAsFloat("fundedamount", fields), (Float)p.getFundedamount());
        Assertions.assertEquals((Float)this.getValueAsFloat("totalcost", fields), (Float)p.getTotalcost());
    }

    @Test
    void testProcessOrganization() throws Exception {
        List<TypedField> fields = this.prepareMocks("organizations_resultset_entry.json");
        List list = this.app.processOrganization(this.rs);
        Assertions.assertEquals((int)1, (int)list.size());
        this.verifyMocks(fields);
        Organization o = (Organization)list.get(0);
        this.assertValidId(o.getId());
        this.assertValidId(((KeyValue)o.getCollectedfrom().get(0)).getKey());
        Assertions.assertEquals((Object)this.getValueAsString("legalshortname", fields), (Object)o.getLegalshortname().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("legalname", fields), (Object)o.getLegalname().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("websiteurl", fields), (Object)o.getWebsiteurl().getValue());
        Assertions.assertEquals((Object)this.getValueAsString("country", fields).split("@@@")[0], (Object)o.getCountry().getClassid());
        Assertions.assertEquals((Object)this.getValueAsString("country", fields).split("@@@")[0], (Object)o.getCountry().getClassname());
        Assertions.assertEquals((Object)this.getValueAsString("country", fields).split("@@@")[1], (Object)o.getCountry().getSchemeid());
        Assertions.assertEquals((Object)this.getValueAsString("country", fields).split("@@@")[1], (Object)o.getCountry().getSchemename());
        Assertions.assertEquals((Object)this.getValueAsString("collectedfromname", fields), (Object)((KeyValue)o.getCollectedfrom().get(0)).getValue());
        List<String> alternativenames = this.getValueAsList("alternativenames", fields);
        Assertions.assertEquals((int)2, (int)alternativenames.size());
        Assertions.assertTrue((boolean)alternativenames.contains("Pippo"));
        Assertions.assertTrue((boolean)alternativenames.contains("Foo"));
    }

    @Test
    void testProcessDatasourceOrganization() throws Exception {
        List<TypedField> fields = this.prepareMocks("datasourceorganization_resultset_entry.json");
        List list = this.app.processServiceOrganization(this.rs);
        Assertions.assertEquals((int)2, (int)list.size());
        this.verifyMocks(fields);
        Relation r1 = (Relation)list.get(0);
        Relation r2 = (Relation)list.get(1);
        this.assertValidId(r1.getSource());
        this.assertValidId(r2.getSource());
        Assertions.assertEquals((Object)r1.getSource(), (Object)r2.getTarget());
        Assertions.assertEquals((Object)r2.getSource(), (Object)r1.getTarget());
        Assertions.assertTrue((boolean)r1.getSource().startsWith("10|"));
        Assertions.assertTrue((boolean)r1.getTarget().startsWith("20|"));
        Assertions.assertEquals((Object)"datasourceOrganization", (Object)r1.getRelType());
        Assertions.assertEquals((Object)"datasourceOrganization", (Object)r2.getRelType());
        Assertions.assertEquals((Object)"provision", (Object)r1.getSubRelType());
        Assertions.assertEquals((Object)"provision", (Object)r2.getSubRelType());
        Assertions.assertEquals((Object)"isProvidedBy", (Object)r1.getRelClass());
        Assertions.assertEquals((Object)"provides", (Object)r2.getRelClass());
    }

    @Test
    void testProcessProjectOrganization() throws Exception {
        List<TypedField> fields = this.prepareMocks("projectorganization_resultset_entry.json");
        List list = this.app.processProjectOrganization(this.rs);
        Assertions.assertEquals((int)2, (int)list.size());
        this.verifyMocks(fields);
        Relation r1 = (Relation)list.get(0);
        Relation r2 = (Relation)list.get(1);
        this.assertValidId(r1.getSource());
        this.assertValidId(r2.getSource());
        Assertions.assertEquals((Object)r1.getSource(), (Object)r2.getTarget());
        Assertions.assertEquals((Object)r2.getSource(), (Object)r1.getTarget());
        this.assertValidId(((KeyValue)r1.getCollectedfrom().get(0)).getKey());
        this.assertValidId(((KeyValue)r2.getCollectedfrom().get(0)).getKey());
        Assertions.assertEquals((Object)"projectOrganization", (Object)r1.getRelType());
        Assertions.assertEquals((Object)"projectOrganization", (Object)r2.getRelType());
        Assertions.assertEquals((Object)"participation", (Object)r1.getSubRelType());
        Assertions.assertEquals((Object)"participation", (Object)r2.getSubRelType());
        if (r1.getSource().startsWith("40")) {
            Assertions.assertEquals((Object)"hasParticipant", (Object)r1.getRelClass());
            Assertions.assertEquals((Object)"isParticipant", (Object)r2.getRelClass());
        } else if (r1.getSource().startsWith("20")) {
            Assertions.assertEquals((Object)"isParticipant", (Object)r1.getRelClass());
            Assertions.assertEquals((Object)"hasParticipant", (Object)r2.getRelClass());
        }
        Assertions.assertNotNull((Object)r1.getProperties());
        this.checkProperty(r1, "contribution", "436754.0");
        this.checkProperty(r2, "contribution", "436754.0");
        this.checkProperty(r1, "currency", "EUR");
        this.checkProperty(r2, "currency", "EUR");
    }

    private void checkProperty(Relation r, String property, String value) {
        List p = r.getProperties().stream().filter(kv -> kv.getKey().equals(property)).collect(Collectors.toList());
        Assertions.assertFalse((boolean)p.isEmpty());
        Assertions.assertEquals((int)1, (int)p.size());
        Assertions.assertEquals((Object)value, (Object)((KeyValue)p.get(0)).getValue());
    }

    @Test
    public void testProcessClaims_context() throws Exception {
        List<TypedField> fields = this.prepareMocks("claimscontext_resultset_entry.json");
        List list = this.app.processClaims(this.rs);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)(list.get(0) instanceof Result));
        Result r = (Result)list.get(0);
        this.verifyMocks(fields);
        this.assertValidId(((KeyValue)r.getCollectedfrom().get(0)).getKey());
    }

    @Test
    void testProcessClaims_rels() throws Exception {
        List<TypedField> fields = this.prepareMocks("claimsrel_resultset_entry.json");
        List list = this.app.processClaims(this.rs);
        Assertions.assertEquals((int)2, (int)list.size());
        this.verifyMocks(fields);
        Assertions.assertTrue((boolean)(list.get(0) instanceof Relation));
        Assertions.assertTrue((boolean)(list.get(1) instanceof Relation));
        Relation r1 = (Relation)list.get(0);
        Relation r2 = (Relation)list.get(1);
        this.assertValidId(r1.getSource());
        this.assertValidId(r1.getTarget());
        this.assertValidId(r2.getSource());
        this.assertValidId(r2.getTarget());
        Assertions.assertNotNull((Object)r1.getDataInfo());
        Assertions.assertNotNull((Object)r2.getDataInfo());
        Assertions.assertNotNull((Object)r1.getDataInfo().getTrust());
        Assertions.assertNotNull((Object)r2.getDataInfo().getTrust());
        Assertions.assertEquals((Object)r1.getSource(), (Object)r2.getTarget());
        Assertions.assertEquals((Object)r2.getSource(), (Object)r1.getTarget());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r1.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r2.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r1.getRelType()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r2.getRelType()));
        this.assertValidId(((KeyValue)r1.getCollectedfrom().get(0)).getKey());
        this.assertValidId(((KeyValue)r2.getCollectedfrom().get(0)).getKey());
    }

    @Test
    void testProcessClaims_affiliation() throws Exception {
        List<TypedField> fields = this.prepareMocks("claimsrel_resultset_affiliation.json");
        List list = this.app.processClaims(this.rs);
        Assertions.assertEquals((int)2, (int)list.size());
        this.verifyMocks(fields);
        Assertions.assertTrue((boolean)(list.get(0) instanceof Relation));
        Assertions.assertTrue((boolean)(list.get(1) instanceof Relation));
        Relation r1 = (Relation)list.get(0);
        Relation r2 = (Relation)list.get(1);
        this.assertValidId(r1.getSource());
        this.assertValidId(r1.getTarget());
        this.assertValidId(r2.getSource());
        this.assertValidId(r2.getTarget());
        Assertions.assertNotNull((Object)r1.getDataInfo());
        Assertions.assertNotNull((Object)r2.getDataInfo());
        Assertions.assertNotNull((Object)r1.getDataInfo().getTrust());
        Assertions.assertNotNull((Object)r2.getDataInfo().getTrust());
        Assertions.assertEquals((Object)r1.getSource(), (Object)r2.getTarget());
        Assertions.assertEquals((Object)r2.getSource(), (Object)r1.getTarget());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r1.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r2.getRelClass()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r1.getRelType()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)r2.getRelType()));
        this.assertValidId(((KeyValue)r1.getCollectedfrom().get(0)).getKey());
        this.assertValidId(((KeyValue)r2.getCollectedfrom().get(0)).getKey());
    }

    private List<TypedField> prepareMocks(String jsonFile) throws IOException, SQLException {
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(jsonFile));
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(json, (TypeReference)new TypeReference<List<TypedField>>(){});
        block34: for (TypedField tf : list) {
            if (tf.getValue() == null) {
                switch (tf.getType()) {
                    case "not_used": {
                        break;
                    }
                    case "boolean": {
                        Mockito.when((Object)this.rs.getBoolean(tf.getField())).thenReturn((Object)false);
                        break;
                    }
                    case "date": {
                        Mockito.when((Object)this.rs.getDate(tf.getField())).thenReturn(null);
                        break;
                    }
                    case "int": {
                        Mockito.when((Object)this.rs.getInt(tf.getField())).thenReturn((Object)0);
                        break;
                    }
                    case "double": {
                        Mockito.when((Object)this.rs.getDouble(tf.getField())).thenReturn((Object)0.0);
                        break;
                    }
                    case "array": {
                        Mockito.when((Object)this.rs.getArray(tf.getField())).thenReturn(null);
                        break;
                    }
                    default: {
                        Mockito.when((Object)this.rs.getString(tf.getField())).thenReturn(null);
                        break;
                    }
                }
                continue;
            }
            switch (tf.getType()) {
                case "not_used": {
                    continue block34;
                }
                case "boolean": {
                    Mockito.when((Object)this.rs.getBoolean(tf.getField())).thenReturn((Object)Boolean.parseBoolean(tf.getValue().toString()));
                    continue block34;
                }
                case "date": {
                    Mockito.when((Object)this.rs.getDate(tf.getField())).thenReturn((Object)Date.valueOf(tf.getValue().toString()));
                    continue block34;
                }
                case "int": {
                    Mockito.when((Object)this.rs.getInt(tf.getField())).thenReturn((Object)new Integer(tf.getValue().toString()));
                    continue block34;
                }
                case "double": {
                    Mockito.when((Object)this.rs.getDouble(tf.getField())).thenReturn((Object)new Double(tf.getValue().toString()));
                    continue block34;
                }
                case "array": {
                    Array arr = (Array)Mockito.mock(Array.class);
                    String[] values = (String[])((List)tf.getValue()).stream().filter(Objects::nonNull).map(Object::toString).toArray(String[]::new);
                    Mockito.when((Object)arr.getArray()).thenReturn((Object)values);
                    Mockito.when((Object)this.rs.getArray(tf.getField())).thenReturn((Object)arr);
                    continue block34;
                }
            }
            Mockito.when((Object)this.rs.getString(tf.getField())).thenReturn((Object)tf.getValue().toString());
        }
        return list;
    }

    private void verifyMocks(List<TypedField> list) throws SQLException {
        block17: for (TypedField tf : list) {
            switch (tf.getType()) {
                case "not_used": {
                    continue block17;
                }
                case "boolean": {
                    ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.atLeastOnce())).getBoolean(tf.getField());
                    continue block17;
                }
                case "date": {
                    ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.atLeastOnce())).getDate(tf.getField());
                    continue block17;
                }
                case "int": {
                    ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.atLeastOnce())).getInt(tf.getField());
                    continue block17;
                }
                case "double": {
                    ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.atLeastOnce())).getDouble(tf.getField());
                    continue block17;
                }
                case "array": {
                    ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.atLeastOnce())).getArray(tf.getField());
                    continue block17;
                }
            }
            ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.atLeastOnce())).getString(tf.getField());
        }
    }

    private void assertValidId(String id) {
        Assertions.assertEquals((int)49, (int)id.length());
        Assertions.assertEquals((char)'|', (char)id.charAt(2));
        Assertions.assertEquals((char)':', (char)id.charAt(15));
        Assertions.assertEquals((char)':', (char)id.charAt(16));
    }

    private String getValueAsString(String name, List<TypedField> fields) {
        return (String)this.getValueAs(name, fields);
    }

    private Float getValueAsFloat(String name, List<TypedField> fields) {
        Object value = this.getValueAs(name, fields);
        return value != null ? new Float(value.toString()) : null;
    }

    private Double getValueAsDouble(String name, List<TypedField> fields) {
        Object value = this.getValueAs(name, fields);
        return value != null ? new Double(value.toString()) : null;
    }

    private Integer getValueAsInt(String name, List<TypedField> fields) {
        Object value = this.getValueAs(name, fields);
        return value != null ? new Integer(value.toString()) : null;
    }

    private <T> T getValueAs(String name, List<TypedField> fields) {
        Optional<Object> field = fields.stream().filter(f -> f.getField().equals(name)).findFirst().map(TypedField::getValue).map(o -> o);
        if (!field.isPresent()) {
            return null;
        }
        return (T)field.get();
    }

    private List<String> getValueAsList(String name, List<TypedField> fields) {
        return (List)this.getValueAs(name, fields);
    }
}

