/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.oa.graph.raw.PatchRelationsApplication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchRelationApplicationTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String ID_MAPPING_PATH = "map/id_mapping.json";
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PatchRelationApplicationTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PatchRelationApplicationTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PatchRelationApplicationTest.class.getSimpleName()).config(conf).getOrCreate();
        FileUtils.copyInputStreamToFile((InputStream)PatchRelationApplicationTest.class.getResourceAsStream("id_mapping.json"), (File)workingDir.resolve(ID_MAPPING_PATH).toFile());
        FileUtils.copyInputStreamToFile((InputStream)PatchRelationApplicationTest.class.getResourceAsStream("relations_to_patch.json"), (File)workingDir.resolve("graphBasePath/relation/rels.json").toFile());
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testPatchRelationApplication() throws Exception {
        String graphBasePath = workingDir.toString() + "/graphBasePath";
        PatchRelationsApplication.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-graphBasePath", graphBasePath, "-workingDir", workingDir + "/workingDir", "-idMappingPath", workingDir + "/" + ID_MAPPING_PATH});
        List rels = spark.read().textFile(graphBasePath + "/relation").map((MapFunction & Serializable)s -> (Relation)OBJECT_MAPPER.readValue(s, Relation.class), Encoders.bean(Relation.class)).collectAsList();
        Assertions.assertEquals((int)6, (int)rels.size());
        Assertions.assertEquals((long)0L, (long)this.getCount(rels, "1a"), (String)"should be patched to 1b");
        Assertions.assertEquals((long)0L, (long)this.getCount(rels, "2a"), (String)"should be patched to 2b");
        Assertions.assertEquals((long)2L, (long)this.getCount(rels, "10a"), (String)"not included in patching");
        Assertions.assertEquals((long)2L, (long)this.getCount(rels, "20a"), (String)"not included in patching");
        Assertions.assertEquals((long)2L, (long)this.getCount(rels, "15a"), (String)"not included in patching");
        Assertions.assertEquals((long)2L, (long)this.getCount(rels, "25a"), (String)"not included in patching");
        Assertions.assertEquals((long)2L, (long)this.getCount(rels, "1b"), (String)"patched from 1a");
        Assertions.assertEquals((long)2L, (long)this.getCount(rels, "2b"), (String)"patched from 2a");
    }

    private long getCount(List<Relation> rels, String id) {
        return rels.stream().filter(r -> r.getSource().equals(id) || r.getTarget().equals(id)).count();
    }

    static {
        log = LoggerFactory.getLogger(PatchRelationApplicationTest.class);
    }
}

