/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.DbClient;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.common.AbstractMigrationApplication;
import eu.dnetlib.dhp.oa.graph.raw.common.MigrateAction;
import eu.dnetlib.dhp.oa.graph.raw.common.VerifyNsPrefixPredicate;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateDbEntitiesApplication
extends AbstractMigrationApplication
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MigrateDbEntitiesApplication.class);
    private static final DataInfo DATA_INFO_CLAIM = OafMapperUtils.dataInfo((Boolean)false, null, (Boolean)false, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"user:claim", (String)"user:claim", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.9");
    private static final List<KeyValue> COLLECTED_FROM_CLAIM = OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)"infrastruct_::openaire", (boolean)true), "OpenAIRE"});
    public static final String SOURCE_TYPE = "source_type";
    public static final String TARGET_TYPE = "target_type";
    private final DbClient dbClient;
    private final long lastUpdateTimestamp;
    private final VocabularyGroup vocs;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateDbEntitiesApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/migrate_db_entities_parameters.json")));
        parser.parseArgument(args);
        String dbUrl = parser.get("postgresUrl");
        log.info("postgresUrl: {}", (Object)dbUrl);
        String dbUser = parser.get("postgresUser");
        log.info("postgresUser: {}", (Object)dbUser);
        String dbPassword = parser.get("postgresPassword");
        log.info("postgresPassword: xxx");
        String dbSchema = parser.get("dbschema");
        log.info("dbSchema {}: ", (Object)dbSchema);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        String hdfsPath = parser.get("hdfsPath");
        log.info("hdfsPath: {}", (Object)hdfsPath);
        String nsPrefixBlacklist = parser.get("nsPrefixBlacklist");
        log.info("nsPrefixBlacklist: {}", (Object)nsPrefixBlacklist);
        VerifyNsPrefixPredicate verifyNamespacePrefix = new VerifyNsPrefixPredicate(nsPrefixBlacklist);
        MigrateAction process = parser.get("action") != null ? MigrateAction.valueOf(parser.get("action")) : MigrateAction.openaire;
        log.info("migrateAction: {}", (Object)process);
        try (MigrateDbEntitiesApplication smdbe = new MigrateDbEntitiesApplication(hdfsPath, dbUrl, dbUser, dbPassword, isLookupUrl);){
            switch (process) {
                case claims: {
                    log.info("Processing claims...");
                    smdbe.execute("queryClaims.sql", smdbe::processClaims);
                    break;
                }
                case openaire: {
                    log.info("Processing services...");
                    smdbe.execute("queryServices.sql", smdbe::processService, verifyNamespacePrefix);
                    log.info("Processing projects...");
                    if (dbSchema.equalsIgnoreCase("beta")) {
                        smdbe.execute("queryProjects.sql", smdbe::processProject, verifyNamespacePrefix);
                    } else {
                        smdbe.execute("queryProjects_production.sql", smdbe::processProject, verifyNamespacePrefix);
                    }
                    log.info("Processing Organizations...");
                    smdbe.execute("queryOrganizations.sql", smdbe::processOrganization, verifyNamespacePrefix);
                    log.info("Processing relations services <-> orgs ...");
                    smdbe.execute("queryServiceOrganization.sql", smdbe::processServiceOrganization, verifyNamespacePrefix);
                    log.info("Processing projects <-> orgs ...");
                    smdbe.execute("queryProjectOrganization.sql", smdbe::processProjectOrganization, verifyNamespacePrefix);
                    break;
                }
                case openorgs_dedup: {
                    log.info("Processing Openorgs...");
                    smdbe.execute("queryOpenOrgsForOrgsDedup.sql", smdbe::processOrganization, verifyNamespacePrefix);
                    log.info("Processing Openorgs Sim Rels...");
                    smdbe.execute("queryOpenOrgsSimilarityForOrgsDedup.sql", smdbe::processOrgOrgSimRels);
                    log.info("Processing Parent/Child Rels...");
                    smdbe.execute("queryOpenOrgsParentChildRelsForOrgsDedup.sql", smdbe::processOrgOrgParentChildRels);
                    break;
                }
                case openorgs: {
                    log.info("Processing Openorgs For Provision...");
                    smdbe.execute("queryOpenOrgsForProvision.sql", smdbe::processOrganization, verifyNamespacePrefix);
                    log.info("Processing Openorgs Merge Rels...");
                    smdbe.execute("queryOpenOrgsSimilarityForProvision.sql", smdbe::processOrgOrgMergeRels);
                    log.info("Processing Openorgs Parent/Child Rels...");
                    smdbe.execute("queryOpenOrgsParentChildRelsForProvision.sql", smdbe::processOrgOrgParentChildRels);
                    break;
                }
                case openaire_organizations: {
                    log.info("Processing Organizations...");
                    smdbe.execute("queryOrganizations.sql", smdbe::processOrganization, verifyNamespacePrefix);
                    log.info("Processing Parent/Child Rels...");
                    smdbe.execute("queryParentChildRelsForOrgsDedup.sql", smdbe::processOrgOrgParentChildRels);
                }
            }
            log.info("All done.");
        }
    }

    protected MigrateDbEntitiesApplication(VocabularyGroup vocs) {
        this.dbClient = null;
        this.lastUpdateTimestamp = new java.util.Date().getTime();
        this.vocs = vocs;
    }

    public MigrateDbEntitiesApplication(String hdfsPath, String dbUrl, String dbUser, String dbPassword, String isLookupUrl) throws Exception {
        super(hdfsPath);
        this.dbClient = new DbClient(dbUrl, dbUser, dbPassword);
        this.lastUpdateTimestamp = new java.util.Date().getTime();
        this.vocs = VocabularyGroup.loadVocsFromIS((ISLookUpService)ISLookupClientFactory.getLookUpService((String)isLookupUrl));
    }

    public void execute(String sqlFile, Function<ResultSet, List<Oaf>> producer) throws Exception {
        this.execute(sqlFile, producer, oaf -> true);
    }

    public void execute(String sqlFile, Function<ResultSet, List<Oaf>> producer, Predicate<Oaf> predicate) throws Exception {
        String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/sql/" + sqlFile));
        Consumer<ResultSet> consumer = rs -> ((List)producer.apply((ResultSet)rs)).forEach(oaf -> {
            if (predicate.test((Oaf)oaf)) {
                this.emitOaf((Oaf)oaf);
            }
        });
        this.dbClient.processResults(sql, consumer);
    }

    public List<Oaf> processService(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Datasource ds = new Datasource();
            ds.setId(OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("id"), (boolean)true));
            ds.setOriginalId(Arrays.asList((String[])rs.getArray("originalid").getArray()).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
            ds.setCollectedfrom(this.prepareCollectedfrom(rs.getArray("collectedfrom")));
            ds.setPid(this.prepareListOfStructProps(rs.getArray("pid"), info));
            ds.setDateofcollection(OafMapperUtils.asString((Object)rs.getDate("dateofcollection")));
            ds.setDateoftransformation(null);
            ds.setExtraInfo(new ArrayList());
            ds.setOaiprovenance(null);
            ds.setDatasourcetype(this.prepareQualifierSplitting(rs.getString("datasourcetype")));
            ds.setDatasourcetypeui(this.prepareQualifierSplitting(rs.getString("datasourcetypeui")));
            ds.setEosctype(this.prepareQualifierSplitting(rs.getString("eosctype")));
            ds.setEoscdatasourcetype(this.prepareQualifierSplitting(rs.getString("eoscdatasourcetype")));
            ds.setOpenairecompatibility(this.prepareQualifierSplitting(rs.getString("openairecompatibility")));
            ds.setOfficialname(OafMapperUtils.field((Object)rs.getString("officialname"), (DataInfo)info));
            ds.setEnglishname(OafMapperUtils.field((Object)rs.getString("englishname"), (DataInfo)info));
            ds.setWebsiteurl(OafMapperUtils.field((Object)rs.getString("websiteurl"), (DataInfo)info));
            ds.setLogourl(OafMapperUtils.field((Object)rs.getString("logourl"), (DataInfo)info));
            ds.setContactemail(OafMapperUtils.field((Object)rs.getString("contactemail"), (DataInfo)info));
            ds.setNamespaceprefix(OafMapperUtils.field((Object)rs.getString("namespaceprefix"), (DataInfo)info));
            ds.setLatitude(OafMapperUtils.field((Object)Double.toString(rs.getDouble("latitude")), (DataInfo)info));
            ds.setLongitude(OafMapperUtils.field((Object)Double.toString(rs.getDouble("longitude")), (DataInfo)info));
            ds.setDateofvalidation(OafMapperUtils.field((Object)OafMapperUtils.asString((Object)rs.getDate("dateofvalidation")), (DataInfo)info));
            ds.setDescription(OafMapperUtils.field((Object)rs.getString("description"), (DataInfo)info));
            ds.setSubjects(this.prepareListOfStructProps(rs.getArray("subjects"), info));
            ds.setOdnumberofitems(OafMapperUtils.field((Object)Double.toString(rs.getInt("odnumberofitems")), (DataInfo)info));
            ds.setOdnumberofitemsdate(OafMapperUtils.field((Object)OafMapperUtils.asString((Object)rs.getDate("odnumberofitemsdate")), (DataInfo)info));
            ds.setOdpolicies(OafMapperUtils.field((Object)rs.getString("odpolicies"), (DataInfo)info));
            ds.setOdlanguages(this.prepareListFields(rs.getArray("odlanguages"), info));
            ds.setLanguages(OafMapperUtils.listValues((Array)rs.getArray("languages")));
            ds.setAccessinfopackage(this.prepareListFields(rs.getArray("accessinfopackage"), info));
            ds.setReleasestartdate(OafMapperUtils.field((Object)OafMapperUtils.asString((Object)rs.getDate("releasestartdate")), (DataInfo)info));
            ds.setReleaseenddate(OafMapperUtils.field((Object)OafMapperUtils.asString((Object)rs.getDate("releaseenddate")), (DataInfo)info));
            ds.setMissionstatementurl(OafMapperUtils.field((Object)rs.getString("missionstatementurl"), (DataInfo)info));
            ds.setDatabaseaccesstype(OafMapperUtils.field((Object)rs.getString("databaseaccesstype"), (DataInfo)info));
            ds.setDatauploadtype(OafMapperUtils.field((Object)rs.getString("datauploadtype"), (DataInfo)info));
            ds.setDatabaseaccessrestriction(OafMapperUtils.field((Object)rs.getString("databaseaccessrestriction"), (DataInfo)info));
            ds.setDatauploadrestriction(OafMapperUtils.field((Object)rs.getString("datauploadrestriction"), (DataInfo)info));
            ds.setVersioning(OafMapperUtils.field((Object)rs.getBoolean("versioning"), (DataInfo)info));
            ds.setVersioncontrol(Boolean.valueOf(rs.getBoolean("versioncontrol")));
            ds.setCitationguidelineurl(OafMapperUtils.field((Object)rs.getString("citationguidelineurl"), (DataInfo)info));
            ds.setPidsystems(OafMapperUtils.field((Object)rs.getString("pidsystems"), (DataInfo)info));
            ds.setCertificates(OafMapperUtils.field((Object)rs.getString("certificates"), (DataInfo)info));
            ds.setPolicies(new ArrayList());
            ds.setJournal(OafMapperUtils.journal((String)rs.getString("officialname"), (String)rs.getString("issnPrinted"), (String)rs.getString("issnOnline"), (String)rs.getString("issnLinking"), (DataInfo)info));
            ds.setResearchentitytypes(OafMapperUtils.listValues((Array)rs.getArray("researchentitytypes")));
            ds.setJurisdiction(this.prepareQualifierSplitting(rs.getString("jurisdiction")));
            ds.setThematic(Boolean.valueOf(rs.getBoolean("thematic")));
            ds.setContentpolicies(this.prepareListOfQualifiers(rs.getArray("contentpolicies")));
            ds.setSubmissionpolicyurl(rs.getString("submissionpolicyurl"));
            ds.setPreservationpolicyurl(rs.getString("preservationpolicyurl"));
            ds.setResearchproductaccesspolicies(OafMapperUtils.listValues((Array)rs.getArray("researchproductaccesspolicies")));
            ds.setResearchproductmetadataaccesspolicies(OafMapperUtils.listValues((Array)rs.getArray("researchproductmetadataaccesspolicies")));
            ds.setConsenttermsofuse(Boolean.valueOf(rs.getBoolean("consenttermsofuse")));
            ds.setFulltextdownload(Boolean.valueOf(rs.getBoolean("fulltextdownload")));
            ds.setConsenttermsofusedate((String)Optional.ofNullable(rs.getDate("consenttermsofusedate")).map(Date::toString).orElse(null));
            ds.setLastconsenttermsofusedate((String)Optional.ofNullable(rs.getDate("lastconsenttermsofusedate")).map(Date::toString).orElse(null));
            ds.setDataInfo(info);
            ds.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(ds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processProject(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Project p = new Project();
            p.setId(OafMapperUtils.createOpenaireId((int)40, (String)rs.getString("projectid"), (boolean)true));
            p.setOriginalId(Arrays.asList(rs.getString("projectid")));
            p.setCollectedfrom(OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")}));
            p.setPid(this.prepareListOfStructProps(rs.getArray("pid"), info));
            p.setDateofcollection(OafMapperUtils.asString((Object)rs.getDate("dateofcollection")));
            p.setDateoftransformation(OafMapperUtils.asString((Object)rs.getDate("dateoftransformation")));
            p.setExtraInfo(new ArrayList());
            p.setOaiprovenance(null);
            p.setWebsiteurl(OafMapperUtils.field((Object)rs.getString("websiteurl"), (DataInfo)info));
            p.setCode(OafMapperUtils.field((Object)rs.getString("code"), (DataInfo)info));
            p.setAcronym(OafMapperUtils.field((Object)rs.getString("acronym"), (DataInfo)info));
            p.setTitle(OafMapperUtils.field((Object)rs.getString("title"), (DataInfo)info));
            p.setStartdate(OafMapperUtils.field((Object)OafMapperUtils.asString((Object)rs.getDate("startdate")), (DataInfo)info));
            p.setEnddate(OafMapperUtils.field((Object)OafMapperUtils.asString((Object)rs.getDate("enddate")), (DataInfo)info));
            p.setCallidentifier(OafMapperUtils.field((Object)rs.getString("callidentifier"), (DataInfo)info));
            p.setKeywords(OafMapperUtils.field((Object)rs.getString("keywords"), (DataInfo)info));
            p.setDuration(OafMapperUtils.field((Object)Integer.toString(rs.getInt("duration")), (DataInfo)info));
            p.setEcsc39(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecsc39")), (DataInfo)info));
            p.setOamandatepublications(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("oamandatepublications")), (DataInfo)info));
            p.setEcarticle29_3(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecarticle29_3")), (DataInfo)info));
            p.setSubjects(this.prepareListOfStructProps(rs.getArray("subjects"), info));
            p.setFundingtree(this.prepareListFields(rs.getArray("fundingtree"), info));
            p.setContracttype(this.prepareQualifierSplitting(rs.getString("contracttype")));
            p.setOptional1(OafMapperUtils.field((Object)rs.getString("optional1"), (DataInfo)info));
            p.setOptional2(OafMapperUtils.field((Object)rs.getString("optional2"), (DataInfo)info));
            p.setJsonextrainfo(OafMapperUtils.field((Object)rs.getString("jsonextrainfo"), (DataInfo)info));
            p.setContactfullname(OafMapperUtils.field((Object)rs.getString("contactfullname"), (DataInfo)info));
            p.setContactfax(OafMapperUtils.field((Object)rs.getString("contactfax"), (DataInfo)info));
            p.setContactphone(OafMapperUtils.field((Object)rs.getString("contactphone"), (DataInfo)info));
            p.setContactemail(OafMapperUtils.field((Object)rs.getString("contactemail"), (DataInfo)info));
            p.setSummary(OafMapperUtils.field((Object)rs.getString("summary"), (DataInfo)info));
            p.setCurrency(OafMapperUtils.field((Object)rs.getString("currency"), (DataInfo)info));
            p.setTotalcost(new Float(rs.getDouble("totalcost")));
            p.setFundedamount(new Float(rs.getDouble("fundedamount")));
            p.setDataInfo(info);
            p.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(p);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Organization o = new Organization();
            o.setId(OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("organizationid"), (boolean)true));
            o.setOriginalId(Arrays.asList(rs.getString("organizationid")));
            o.setCollectedfrom(OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")}));
            o.setPid(this.prepareListOfStructProps(rs.getArray("pid"), info));
            o.setDateofcollection(OafMapperUtils.asString((Object)rs.getDate("dateofcollection")));
            o.setDateoftransformation(OafMapperUtils.asString((Object)rs.getDate("dateoftransformation")));
            o.setExtraInfo(new ArrayList());
            o.setOaiprovenance(null);
            o.setLegalshortname(OafMapperUtils.field((Object)rs.getString("legalshortname"), (DataInfo)info));
            o.setLegalname(OafMapperUtils.field((Object)rs.getString("legalname"), (DataInfo)info));
            o.setAlternativeNames(this.prepareListFields(rs.getArray("alternativenames"), info));
            o.setWebsiteurl(OafMapperUtils.field((Object)rs.getString("websiteurl"), (DataInfo)info));
            o.setLogourl(OafMapperUtils.field((Object)rs.getString("logourl"), (DataInfo)info));
            o.setEclegalbody(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("eclegalbody")), (DataInfo)info));
            o.setEclegalperson(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("eclegalperson")), (DataInfo)info));
            o.setEcnonprofit(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecnonprofit")), (DataInfo)info));
            o.setEcresearchorganization(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecresearchorganization")), (DataInfo)info));
            o.setEchighereducation(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("echighereducation")), (DataInfo)info));
            o.setEcinternationalorganizationeurinterests(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecinternationalorganizationeurinterests")), (DataInfo)info));
            o.setEcinternationalorganization(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecinternationalorganization")), (DataInfo)info));
            o.setEcenterprise(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecenterprise")), (DataInfo)info));
            o.setEcsmevalidated(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecsmevalidated")), (DataInfo)info));
            o.setEcnutscode(OafMapperUtils.field((Object)Boolean.toString(rs.getBoolean("ecnutscode")), (DataInfo)info));
            o.setCountry(this.prepareQualifierSplitting(rs.getString("country")));
            o.setOrganizationType(Organization.OrganizationType.valueOf((String)rs.getString("typology")));
            o.setDataInfo(info);
            o.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            return Arrays.asList(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processServiceOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("organization"), (boolean)true);
            String dsId = OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("service"), (boolean)true);
            List collectedFrom = OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")});
            Relation r1 = OafMapperUtils.getRelation((String)dsId, (String)orgId, (String)"datasourceOrganization", (String)"provision", (String)"isProvidedBy", (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp);
            Relation r2 = OafMapperUtils.getRelation((String)orgId, (String)dsId, (String)"datasourceOrganization", (String)"provision", (String)"provides", (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp);
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processProjectOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("resporganization"), (boolean)true);
            String projectId = OafMapperUtils.createOpenaireId((int)40, (String)rs.getString("project"), (boolean)true);
            List collectedFrom = OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")});
            ArrayList properties = Lists.newArrayList((Object[])new KeyValue[]{OafMapperUtils.keyValue((String)"contribution", (String)String.valueOf(rs.getDouble("contribution"))), OafMapperUtils.keyValue((String)"currency", (String)rs.getString("currency"))});
            Relation r1 = OafMapperUtils.getRelation((String)projectId, (String)orgId, (String)"projectOrganization", (String)"participation", (String)"hasParticipant", (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp, null, (List)properties);
            Relation r2 = OafMapperUtils.getRelation((String)orgId, (String)projectId, (String)"projectOrganization", (String)"participation", (String)"isParticipant", (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp, null, (List)properties);
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processClaims(ResultSet rs) {
        try {
            String semantics;
            String sourceType = rs.getString(SOURCE_TYPE);
            String targetType = rs.getString(TARGET_TYPE);
            if (sourceType.equals("context")) {
                Dataset r;
                if (targetType.equals("dataset")) {
                    r = new Dataset();
                    r.setResulttype(ModelConstants.DATASET_DEFAULT_RESULTTYPE);
                } else if (targetType.equals("software")) {
                    r = new Software();
                    r.setResulttype(ModelConstants.SOFTWARE_DEFAULT_RESULTTYPE);
                } else if (targetType.equals("other")) {
                    r = new OtherResearchProduct();
                    r.setResulttype(ModelConstants.ORP_DEFAULT_RESULTTYPE);
                } else {
                    r = new Publication();
                    r.setResulttype(ModelConstants.PUBLICATION_DEFAULT_RESULTTYPE);
                }
                r.setId(OafMapperUtils.createOpenaireId((int)50, (String)rs.getString("target_id"), (boolean)false));
                r.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
                r.setContext(this.prepareContext(rs.getString("source_id"), DATA_INFO_CLAIM));
                r.setDataInfo(DATA_INFO_CLAIM);
                r.setCollectedfrom(COLLECTED_FROM_CLAIM);
                return Arrays.asList(r);
            }
            String validationDate = rs.getString("curation_date");
            String sourceId = OafMapperUtils.createOpenaireId((String)sourceType, (String)rs.getString("source_id"), (boolean)false);
            String targetId = OafMapperUtils.createOpenaireId((String)targetType, (String)rs.getString("target_id"), (boolean)false);
            Relation r1 = this.prepareRelation(sourceId, targetId, validationDate);
            Relation r2 = this.prepareRelation(targetId, sourceId, validationDate);
            switch (semantics = rs.getString("semantics")) {
                case "resultResult_relationship_isRelatedTo": {
                    r1 = this.setRelationSemantic(r1, "resultResult", "relationship", "IsRelatedTo");
                    r2 = this.setRelationSemantic(r2, "resultResult", "relationship", "IsRelatedTo");
                    break;
                }
                case "resultProject_outcome_produces": {
                    if (!"project".equals(sourceType)) {
                        throw new IllegalStateException(String.format("invalid claim, sourceId: %s, targetId: %s, semantics: %s", sourceId, targetId, semantics));
                    }
                    r1 = this.setRelationSemantic(r1, "resultProject", "outcome", "produces");
                    r2 = this.setRelationSemantic(r2, "resultProject", "outcome", "isProducedBy");
                    break;
                }
                case "resultResult_publicationDataset_isRelatedTo": {
                    r1 = this.setRelationSemantic(r1, "resultResult", "publicationDataset", "IsRelatedTo");
                    r2 = this.setRelationSemantic(r2, "resultResult", "publicationDataset", "IsRelatedTo");
                    break;
                }
                case "resultOrganization_affiliation_isAuthorInstitutionOf": {
                    if (!"organization".equals(sourceType)) {
                        throw new IllegalStateException(String.format("invalid claim, sourceId: %s, targetId: %s, semantics: %s", sourceId, targetId, semantics));
                    }
                    r1 = this.setRelationSemantic(r1, "resultOrganization", "affiliation", "isAuthorInstitutionOf");
                    r2 = this.setRelationSemantic(r2, "resultOrganization", "affiliation", "hasAuthorInstitution");
                    break;
                }
                case "resultOrganization_affiliation_hasAuthorInstitution": {
                    if (!"organization".equals(targetType)) {
                        throw new IllegalStateException(String.format("invalid claim, sourceId: %s, targetId: %s, semantics: %s", sourceId, targetId, semantics));
                    }
                    r1 = this.setRelationSemantic(r1, "resultOrganization", "affiliation", "hasAuthorInstitution");
                    r2 = this.setRelationSemantic(r2, "resultOrganization", "affiliation", "isAuthorInstitutionOf");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("claim semantics not managed: " + semantics);
                }
            }
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Relation prepareRelation(String sourceId, String targetId, String validationDate) {
        Relation r = new Relation();
        if (StringUtils.isNotBlank((CharSequence)validationDate)) {
            r.setValidated(Boolean.valueOf(true));
            r.setValidationDate(validationDate);
        }
        r.setCollectedfrom(COLLECTED_FROM_CLAIM);
        r.setSource(sourceId);
        r.setTarget(targetId);
        r.setDataInfo(DATA_INFO_CLAIM);
        r.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
        return r;
    }

    private Relation setRelationSemantic(Relation r, String relType, String subRelType, String relClass) {
        r.setRelType(relType);
        r.setSubRelType(subRelType);
        r.setRelClass(relClass);
        return r;
    }

    private List<Context> prepareContext(String id, DataInfo dataInfo) {
        Context context = new Context();
        context.setId(id);
        context.setDataInfo(Arrays.asList(dataInfo));
        return Arrays.asList(context);
    }

    private DataInfo prepareDataInfo(ResultSet rs) throws SQLException {
        Boolean deletedbyinference = rs.getBoolean("deletedbyinference");
        String inferenceprovenance = rs.getString("inferenceprovenance");
        Boolean inferred = rs.getBoolean("inferred");
        double trust = rs.getDouble("trust");
        return OafMapperUtils.dataInfo((Boolean)deletedbyinference, (String)inferenceprovenance, (Boolean)inferred, (Boolean)false, (Qualifier)ModelConstants.ENTITYREGISTRY_PROVENANCE_ACTION, (String)String.format("%.3f", trust));
    }

    private List<KeyValue> prepareCollectedfrom(Array values) throws SQLException {
        if (Objects.isNull(values)) {
            return null;
        }
        return Arrays.stream((String[])values.getArray()).filter(Objects::nonNull).distinct().map(s -> MigrateDbEntitiesApplication.keyValueSplitting(s, "@@@")).collect(Collectors.toList());
    }

    public static KeyValue keyValueSplitting(String s, String separator) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] arr = s.split(separator);
        if (arr.length != 2) {
            return null;
        }
        KeyValue kv = new KeyValue();
        kv.setKey(OafMapperUtils.createOpenaireId((int)10, (String)arr[0], (boolean)true));
        kv.setValue(arr[1]);
        return kv;
    }

    private Qualifier prepareQualifierSplitting(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] arr = s.split("@@@");
        return arr.length == 2 ? this.vocs.getTermAsQualifier(arr[1], arr[0]) : null;
    }

    private List<Field<String>> prepareListFields(Array array, DataInfo info) {
        try {
            return array != null ? OafMapperUtils.listFields((DataInfo)info, (String[])((String[])array.getArray())) : new ArrayList<Field<String>>();
        }
        catch (SQLException e) {
            throw new RuntimeException("Invalid SQL array", e);
        }
    }

    private StructuredProperty prepareStructProp(String s, DataInfo dataInfo) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] parts = s.split("###");
        if (parts.length == 2) {
            String value = parts[0];
            String[] arr = parts[1].split("@@@");
            if (arr.length == 2) {
                return OafMapperUtils.structuredProperty((String)value, (Qualifier)this.vocs.getTermAsQualifier(arr[1], arr[0]), (DataInfo)dataInfo);
            }
        }
        return null;
    }

    private List<StructuredProperty> prepareListOfStructProps(Array array, DataInfo dataInfo) throws SQLException {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        if (array != null) {
            for (String s : (String[])array.getArray()) {
                StructuredProperty sp = this.prepareStructProp(s, dataInfo);
                if (sp == null) continue;
                res.add(sp);
            }
        }
        return res;
    }

    private List<Qualifier> prepareListOfQualifiers(Array array) throws SQLException {
        ArrayList<Qualifier> res = new ArrayList<Qualifier>();
        if (array != null) {
            for (String s : (String[])array.getArray()) {
                Qualifier q = this.prepareQualifierSplitting(s);
                if (q == null) continue;
                res.add(q);
            }
        }
        return res;
    }

    public List<Oaf> processOrgOrgMergeRels(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId1 = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("id1"), (boolean)true);
            String orgId2 = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("id2"), (boolean)true);
            List collectedFrom = OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")});
            Relation r1 = OafMapperUtils.getRelation((String)orgId1, (String)orgId2, (String)"organizationOrganization", (String)"dedup", (String)"merges", (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp);
            Relation r2 = OafMapperUtils.getRelation((String)orgId2, (String)orgId1, (String)"organizationOrganization", (String)"dedup", (String)"isMergedIn", (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp);
            return Arrays.asList(r1, r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processOrgOrgParentChildRels(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId1 = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("source"), (boolean)true);
            String orgId2 = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("target"), (boolean)true);
            List collectedFrom = OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")});
            return Arrays.asList(OafMapperUtils.getRelation((String)orgId1, (String)orgId2, (String)"organizationOrganization", (String)"relationship", (String)rs.getString("type"), (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oaf> processOrgOrgSimRels(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId1 = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("id1"), (boolean)true);
            String orgId2 = OafMapperUtils.createOpenaireId((int)20, (String)rs.getString("id2"), (boolean)true);
            String relClass = rs.getString("relclass");
            List collectedFrom = OafMapperUtils.listKeyValues((String[])new String[]{OafMapperUtils.createOpenaireId((int)10, (String)rs.getString("collectedfromid"), (boolean)true), rs.getString("collectedfromname")});
            return Arrays.asList(OafMapperUtils.getRelation((String)orgId1, (String)orgId2, (String)"organizationOrganization", (String)"dedup", (String)relClass, (List)collectedFrom, (DataInfo)info, (Long)this.lastUpdateTimestamp));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.dbClient.close();
    }
}

