/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.resolution;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.graph.resolution.SparkResolveEntities$;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

public final class SparkResolveEntities$ {
    public static final SparkResolveEntities$ MODULE$;
    private final ObjectMapper mapper;
    private final List<EntityType> entities;

    static {
        new SparkResolveEntities$();
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public List<EntityType> entities() {
        return this.entities;
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/resolution/resolve_entities_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String graphBasePath = parser.get("graphBasePath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"graphBasePath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{graphBasePath})));
        String workingPath = parser.get("workingPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"workingPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath})));
        String unresolvedPath = parser.get("unresolvedPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unresolvedPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unresolvedPath})));
        String targetPath = parser.get("targetPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targetPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
        fs.mkdirs(new Path(workingPath));
        this.resolveEntities(spark, workingPath, unresolvedPath);
        this.generateResolvedEntities(spark, workingPath, graphBasePath, targetPath);
    }

    public void resolveEntities(SparkSession spark, String workingPath, String unresolvedPath) {
        Encoder resEncoder = Encoders$.MODULE$.kryo(Result.class);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_oa_graph_resolution_SparkResolveEntities$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
            }

            public Eu_dnetlib_dhp_oa_graph_resolution_SparkResolveEntities$$typecreator4$1() {
            }
        }
        org.apache.spark.sql.Dataset rPid = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/relationResolvedPid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath}))).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_oa_graph_resolution_SparkResolveEntities$$typecreator4$1())));
        org.apache.spark.sql.Dataset up = spark.read().text(unresolvedPath).as(spark.implicits().newStringEncoder()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Result apply(String s) {
                return (Result)SparkResolveEntities$.MODULE$.mapper().readValue(s, Result.class);
            }
        }, resEncoder).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Result> apply(Result r) {
                return new Tuple2((Object)r.getId(), (Object)r);
            }
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), resEncoder));
        rPid.joinWith(up, rPid.apply("_2").equalTo((Object)up.apply("_1")), "inner").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Result apply(Tuple2<Tuple2<String, String>, Tuple2<String, Result>> r) {
                void var2_2;
                Result result = (Result)((Tuple2)r._2())._2();
                String dnetId = (String)((Tuple2)r._1())._1();
                result.setId(dnetId);
                return var2_2;
            }
        }, resEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/resolvedEntities"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath})));
    }

    public Result deserializeObject(String input, EntityType entity) {
        EntityType entityType;
        block6: {
            Result result;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            entityType = entity;
                            if (!EntityType.publication.equals(entityType)) break block2;
                            result = (Result)this.mapper().readValue(input, Publication.class);
                            break block3;
                        }
                        if (!EntityType.dataset.equals(entityType)) break block4;
                        result = (Result)this.mapper().readValue(input, Dataset.class);
                        break block3;
                    }
                    if (!EntityType.software.equals(entityType)) break block5;
                    result = (Result)this.mapper().readValue(input, Software.class);
                    break block3;
                }
                if (!EntityType.otherresearchproduct.equals(entityType)) break block6;
                result = (Result)this.mapper().readValue(input, OtherResearchProduct.class);
            }
            return result;
        }
        throw new MatchError((Object)entityType);
    }

    public void generateResolvedEntities(SparkSession spark, String workingPath, String graphBasePath, String targetPath) {
        Encoder resEncoder = Encoders$.MODULE$.kryo(Result.class);
        org.apache.spark.sql.Dataset re = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/resolvedEntities"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath}))).as(resEncoder).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Result> apply(Result r) {
                return new Tuple2((Object)r.getId(), (Object)r);
            }
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), resEncoder));
        this.entities().foreach((Function1)new Serializable(spark, graphBasePath, targetPath, resEncoder, re){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final String graphBasePath$1;
            private final String targetPath$1;
            private final Encoder resEncoder$1;
            private final org.apache.spark.sql.Dataset re$1;

            public final void apply(EntityType e) {
                org.apache.spark.sql.Dataset currentEntityDataset = this.spark$1.read().text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.graphBasePath$1, e}))).as(this.spark$1.implicits().newStringEncoder()).map((Function1)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final EntityType e$1;

                    public final Result apply(String s) {
                        return SparkResolveEntities$.MODULE$.deserializeObject(s, this.e$1);
                    }
                    {
                        this.e$1 = e$1;
                    }
                }, this.resEncoder$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Result> apply(Result r) {
                        return new Tuple2((Object)r.getId(), (Object)r);
                    }
                }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), this.resEncoder$1));
                currentEntityDataset.joinWith(this.re$1, currentEntityDataset.apply("_1").equalTo((Object)this.re$1.apply("_1")), "left").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Result apply(Tuple2<Tuple2<String, Result>, Tuple2<String, Result>> k) {
                        Tuple2 a = (Tuple2)k._1();
                        Tuple2 b = (Tuple2)k._2();
                        return b == null ? (Result)a._2() : MergeUtils.mergeResult((Result)((Result)a._2()), (Result)((Result)b._2()));
                    }
                }, this.resEncoder$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Result r) {
                        return SparkResolveEntities$.MODULE$.mapper().writeValueAsString((Object)r);
                    }
                }, Encoders$.MODULE$.STRING()).write().mode(SaveMode.Overwrite).option("compression", "gzip").text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetPath$1, e})));
            }
            {
                this.spark$1 = spark$1;
                this.graphBasePath$1 = graphBasePath$1;
                this.targetPath$1 = targetPath$1;
                this.resEncoder$1 = resEncoder$1;
                this.re$1 = re$1;
            }
        });
    }

    private SparkResolveEntities$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
        this.entities = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EntityType[]{EntityType.dataset, EntityType.publication, EntityType.software, EntityType.otherresearchproduct}));
    }
}

